/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.api;

import br.pucrio.tecgraf.soma.job.api.MultiflowApiService;
import br.pucrio.tecgraf.soma.job.api.NotFoundException;
import br.pucrio.tecgraf.soma.job.api.factories.MultiflowApiServiceFactory;
import br.pucrio.tecgraf.soma.job.api.model.Multiflow;
import br.pucrio.tecgraf.soma.job.api.model.MultiflowBasicResponse;
import br.pucrio.tecgraf.soma.job.api.model.MultiflowFullResponse;
import br.pucrio.tecgraf.soma.job.api.model.ReplicaFile;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.servlet.ServletConfig;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/multiflow")
@Api(description="the multiflow API")
public class MultiflowApi {
    private final MultiflowApiService delegate;

    public MultiflowApi(@Context ServletConfig servletContext) {
        String implClass;
        MultiflowApiService delegate = null;
        if (servletContext != null && (implClass = servletContext.getInitParameter("MultiflowApi.implementation")) != null && !"".equals(implClass.trim())) {
            try {
                delegate = (MultiflowApiService)Class.forName(implClass).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (delegate == null) {
            delegate = MultiflowApiServiceFactory.getMultiflowApi();
        }
        this.delegate = delegate;
    }

    @GET
    @Produces(value={"application/json;"})
    @ApiOperation(value="Get multiflows from a certain project", notes="This endpoint list all multiflows from a certain project", response=MultiflowFullResponse.class, tags={"Multiflows"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation.", response=MultiflowFullResponse.class), @ApiResponse(code=401, message="No authorization token.", response=Void.class), @ApiResponse(code=403, message="The authenticated user does not have permission to access the project.", response=Void.class), @ApiResponse(code=400, message="Invalid or missing parameters.", response=Void.class), @ApiResponse(code=500, message="Processing error occurred during the multiflows search.", response=Void.class), @ApiResponse(code=503, message="Server is currently unable to handle the request.", response=Void.class)})
    public Response multiflowGet(@ApiParam(value="Project identifier", required=true) @QueryParam(value="projectId") @NotNull String projectId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.multiflowGet(projectId, locale, securityContext);
    }

    @GET
    @Path(value="/{multiflowId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a specific multiflow from its unique identifier", notes="This endpoint gets a single multiflow from its unique identifier", response=MultiflowFullResponse.class, tags={"Multiflows"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation.", response=MultiflowFullResponse.class), @ApiResponse(code=401, message="No authorization token.", response=Void.class), @ApiResponse(code=403, message="The authenticated user does not have permission to access the project.", response=Void.class), @ApiResponse(code=400, message="Invalid or missing parameters.", response=Void.class), @ApiResponse(code=500, message="Processing error occurred during the multiflow search.", response=Void.class), @ApiResponse(code=503, message="Server is currently unable to handle the request.", response=Void.class)})
    public Response multiflowMultiflowIdGet(@ApiParam(value="Multiflow identifier", required=true) @PathParam(value="multiflowId") @NotNull Long multiflowId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.multiflowMultiflowIdGet(multiflowId, locale, securityContext);
    }

    @PATCH
    @Path(value="/{multiflowId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Updates a multiflow from its unique identifier.", notes="This endpoint updates the file name and file path of a multiflow from its unique identifier. If no file name is passed then the file path is used as file name.", response=MultiflowFullResponse.class, tags={"Multiflows"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation.", response=MultiflowFullResponse.class), @ApiResponse(code=401, message="No authorization token.", response=Void.class), @ApiResponse(code=403, message="The authenticated user does not have permission to access the project.", response=Void.class), @ApiResponse(code=400, message="Invalid or missing parameters.", response=Void.class), @ApiResponse(code=500, message="Processing error occurred during the request.", response=Void.class), @ApiResponse(code=503, message="Server is currently unable to handle the request.", response=Void.class)})
    public Response multiflowMultiflowIdPatch(@ApiParam(value="Multiflow identifier", required=true) @PathParam(value="multiflowId") @NotNull Long multiflowId, @ApiParam(value="Required information to update the file name and file path of a multiflow.", required=true) @NotNull @Valid ReplicaFile replicaFile, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.multiflowMultiflowIdPatch(multiflowId, replicaFile, locale, securityContext);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a multiflow", notes="This endpoint creates a multiflow, which is combination of flow with replica table.", response=MultiflowBasicResponse.class, tags={"Multiflows"})
    @ApiResponses(value={@ApiResponse(code=201, message="New multiflow created.", response=MultiflowBasicResponse.class), @ApiResponse(code=400, message="Missing body parameter(s).", response=Void.class), @ApiResponse(code=401, message="No authorization token.", response=Void.class), @ApiResponse(code=403, message="The authenticated user does not have permission to access the project.", response=Void.class), @ApiResponse(code=404, message="Multiflow not found.", response=Void.class), @ApiResponse(code=500, message="Processing error occurred during the multiflow creation.", response=Void.class), @ApiResponse(code=503, message="Server is currently unable to handle the request.", response=Void.class)})
    public Response multiflowPost(@ApiParam(value="Required information to create a multiflow", required=true) @NotNull @Valid Multiflow multiflow, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.multiflowPost(multiflow, locale, securityContext);
    }
}

