/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.appservice;

import br.pucrio.tecgraf.soma.job.api.model.MultiflowBasicResponse;
import br.pucrio.tecgraf.soma.job.api.model.MultiflowFullResponse;
import br.pucrio.tecgraf.soma.job.application.service.FlowService;
import br.pucrio.tecgraf.soma.job.application.service.MultiflowService;
import br.pucrio.tecgraf.soma.job.application.service.ProjectService;
import br.pucrio.tecgraf.soma.job.application.service.ReplicaFileService;
import br.pucrio.tecgraf.soma.job.domain.model.Flow;
import br.pucrio.tecgraf.soma.job.domain.model.Multiflow;
import br.pucrio.tecgraf.soma.job.domain.model.MultiflowReplicaFile;
import br.pucrio.tecgraf.soma.job.domain.model.ReplicaFile;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.ForbiddenException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MultiflowAppService {
    @Autowired
    private ProjectService projectService;
    @Autowired
    private MultiflowService multiflowService;
    @Autowired
    private FlowService flowService;
    @Autowired
    private ReplicaFileService replicaFileService;

    @Transactional
    public MultiflowBasicResponse createMultiflow(br.pucrio.tecgraf.soma.job.api.model.Multiflow multiflowData) {
        if (!this.projectService.hasPermission(multiflowData.getProjectId())) {
            throw new ForbiddenException("User has no permission to add a Multiflow to this project");
        }
        Flow flow = new Flow();
        flow.setName(multiflowData.getFlowName());
        flow.setFlowData(multiflowData.getFlowData());
        flow.setLayoutData(multiflowData.getLayoutData());
        this.flowService.createFlow(flow);
        Multiflow multiflow = new Multiflow();
        String name = multiflowData.getName();
        if (name == null || name.trim().length() == 0) {
            name = multiflowData.getFlowName();
        }
        multiflow.setName(name);
        multiflow.setFlow(flow);
        multiflow.setProjectId(multiflowData.getProjectId());
        Multiflow created = this.multiflowService.createMultiflow(multiflow);
        return MultiflowAppService.convertToBasicRESTModel((Multiflow)created);
    }

    @Transactional(readOnly=true)
    public List<MultiflowFullResponse> findMultiflowsByProjectId(String projectId) {
        if (!this.projectService.hasPermission(projectId)) {
            throw new ForbiddenException("User has no permission to get Multiflows from this project");
        }
        List multiflows = this.multiflowService.findMultiflowsByProjectId(projectId);
        return multiflows.stream().map(mf -> MultiflowAppService.convertToFullRESTModel((Multiflow)mf)).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public MultiflowFullResponse findMultiflowById(Long multiflowId) {
        Multiflow multiflow = this.multiflowService.findMultiflowById(multiflowId);
        if (!this.projectService.hasPermission(multiflow.getProjectId())) {
            throw new ForbiddenException("User has no permission to get this Multiflow");
        }
        return MultiflowAppService.convertToFullRESTModel((Multiflow)multiflow);
    }

    @Transactional
    public MultiflowFullResponse updateMultiflow(Long multiflowId, String updatedPath, String updatedName, Object parameterMapping) {
        boolean shouldCreateNewReplicaFile;
        Multiflow multiflow = this.multiflowService.findMultiflowById(multiflowId);
        if (!this.projectService.hasPermission(multiflow.getProjectId())) {
            throw new ForbiddenException("User has no permission to get this Multiflow");
        }
        List multiflowReplicaFiles = multiflow.getMultiflowReplicaFiles();
        boolean bl = shouldCreateNewReplicaFile = updatedPath != null && !updatedPath.trim().isEmpty();
        if (shouldCreateNewReplicaFile) {
            this.setAllNonDeletedMultiflowReplicaFilesAsDeleted(multiflowReplicaFiles);
            ReplicaFile newReplicaFile = new ReplicaFile();
            newReplicaFile.setName(updatedName);
            newReplicaFile.setPath(updatedPath);
            this.replicaFileService.createReplicaFile(newReplicaFile);
            MultiflowReplicaFile fileAssociation = new MultiflowReplicaFile();
            fileAssociation.setReplicaFile(newReplicaFile);
            fileAssociation.setIsDeleted(false);
            fileAssociation.setParameterMapping(parameterMapping);
            multiflow.addMultiflowReplicaFile(fileAssociation);
        } else {
            MultiflowReplicaFile currentMultiflowReplicaFile = this.setOnlyCurrentMultiflowReplicaFileAsNonDeleted(multiflowReplicaFiles);
            if (parameterMapping != null) {
                currentMultiflowReplicaFile.setParameterMapping(parameterMapping);
            }
            if (updatedName != null) {
                currentMultiflowReplicaFile.getReplicaFile().setName(updatedName);
            }
        }
        multiflow.setLastModifiedTime(LocalDateTime.now(ZoneOffset.UTC));
        Multiflow updatedMultiflow = this.multiflowService.updateMultiflow(multiflow);
        return MultiflowAppService.convertToFullRESTModel((Multiflow)updatedMultiflow);
    }

    private static MultiflowBasicResponse convertToBasicRESTModel(Multiflow dbModel) {
        MultiflowBasicResponse restModel = new MultiflowBasicResponse();
        restModel.setId(Long.valueOf(dbModel.getId()));
        restModel.setFlowName(dbModel.getFlow().getName());
        restModel.setName(dbModel.getName());
        restModel.setCreationTime(Date.from(dbModel.getCreationTime().toInstant(ZoneOffset.UTC)));
        restModel.setLastModifiedTime(Date.from(dbModel.getLastModifiedTime().toInstant(ZoneOffset.UTC)));
        return restModel;
    }

    private static MultiflowFullResponse convertToFullRESTModel(Multiflow dbModel) {
        MultiflowFullResponse restModel = new MultiflowFullResponse();
        restModel.setId(Long.valueOf(dbModel.getId()));
        restModel.setFlowName(dbModel.getFlow().getName());
        restModel.setName(dbModel.getName());
        restModel.setCreationTime(Date.from(dbModel.getCreationTime().toInstant(ZoneOffset.UTC)));
        restModel.setLastModifiedTime(Date.from(dbModel.getLastModifiedTime().toInstant(ZoneOffset.UTC)));
        restModel.setFlowData(dbModel.getFlow().getFlowData());
        restModel.setLayoutData(dbModel.getFlow().getLayoutData());
        restModel.setProjectId(dbModel.getProjectId());
        List replicaFiles = dbModel.getMultiflowReplicaFiles();
        List nonDeletedFiles = replicaFiles.stream().filter(f -> !f.isDeleted()).sorted(Comparator.comparing(MultiflowReplicaFile::getId, (a, b) -> b.compareTo((Long)a))).collect(Collectors.toList());
        if (!nonDeletedFiles.isEmpty()) {
            MultiflowReplicaFile fileAssociation = (MultiflowReplicaFile)nonDeletedFiles.get(0);
            ReplicaFile replicaFile = fileAssociation.getReplicaFile();
            restModel.setReplicaFilePath(replicaFile.getPath());
            restModel.setReplicaFileName(replicaFile.getName());
            Object parameterMapping = fileAssociation.getParameterMapping();
            if (parameterMapping instanceof String) {
                ObjectMapper jsonMapper = new ObjectMapper();
                try {
                    parameterMapping = jsonMapper.readValue((String)parameterMapping, Map.class);
                }
                catch (Exception e) {
                    parameterMapping = null;
                    e.printStackTrace();
                }
            }
            restModel.setParameterMapping(parameterMapping);
        }
        return restModel;
    }

    private void setAllNonDeletedMultiflowReplicaFilesAsDeleted(List<MultiflowReplicaFile> allMultiflowReplicaFiles) {
        this.setNonDeletedMultiflowReplicaFilesAsDeleted(allMultiflowReplicaFiles, false);
    }

    private MultiflowReplicaFile setOnlyCurrentMultiflowReplicaFileAsNonDeleted(List<MultiflowReplicaFile> allMultiflowReplicaFiles) {
        List validAssociations = this.setNonDeletedMultiflowReplicaFilesAsDeleted(allMultiflowReplicaFiles, true);
        return (MultiflowReplicaFile)validAssociations.get(validAssociations.size() - 1);
    }

    private List<MultiflowReplicaFile> setNonDeletedMultiflowReplicaFilesAsDeleted(List<MultiflowReplicaFile> allMultiflowReplicaFiles, boolean exceptLast) {
        List<MultiflowReplicaFile> validAssociations = allMultiflowReplicaFiles.stream().filter(f -> !f.isDeleted()).collect(Collectors.toList());
        int maxIndex = validAssociations.size() - (exceptLast ? 1 : 0);
        for (int i = 0; i < maxIndex; ++i) {
            MultiflowReplicaFile validadAssociation = validAssociations.get(i);
            validadAssociation.setIsDeleted(true);
        }
        return validAssociations;
    }
}

