/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.filter;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=2)
public class RequestLogFilter
implements Filter {
    private static final Logger LOG = Logger.getLogger(RequestLogFilter.class);

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse res = (HttpServletResponse)servletResponse;
        LOG.info((Object)String.format("Received request  %s : %s", req.getMethod(), req.getRequestURI()));
        StringBuilder sb = new StringBuilder();
        sb.append("Request parameters: {");
        Iterator it = req.getParameterMap().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry parameter = it.next();
            sb.append((String)parameter.getKey()).append("=");
            Object[] values = (String[])parameter.getValue();
            if (values.length == 0) {
                sb.append("null");
            } else if (values.length == 1) {
                sb.append((String)values[0]);
            } else {
                sb.append(Arrays.toString(values));
            }
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        LOG.debug((Object)sb.toString());
        filterChain.doFilter(servletRequest, servletResponse);
        LOG.info((Object)"Sending response");
    }
}

