/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.filter;

import br.pucrio.tecgraf.soma.job.application.filter.ServiceRequestContext;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.jboss.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class ServiceRequestContextFilter
implements Filter {
    private static final Logger LOG = Logger.getLogger(ServiceRequestContextFilter.class);
    @Autowired
    private ServiceRequestContext serviceRequestContext;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        LOG.info((Object)"Putting context in the request scope");
        this.serviceRequestContext.setToken(this.getAuthToken(httpRequest));
        this.serviceRequestContext.setLocale(this.getLocale(httpRequest));
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private String getAuthToken(HttpServletRequest httpRequest) {
        return httpRequest.getHeader("Authorization");
    }

    private String getLocale(HttpServletRequest httpRequest) {
        String localeKey = "locale";
        String[] localeParamValues = httpRequest.getParameterValues(localeKey);
        if (localeParamValues == null || localeParamValues.length == 0) {
            return null;
        }
        return localeParamValues[0];
    }
}

