package br.pucrio.tecgraf.soma.job.api;

import br.pucrio.tecgraf.soma.job.api.JobsApiService;
import br.pucrio.tecgraf.soma.job.api.factories.JobsApiServiceFactory;

import io.swagger.annotations.ApiParam;
import io.swagger.jaxrs.*;

import br.pucrio.tecgraf.soma.job.api.model.AlgorithmResponse;
import br.pucrio.tecgraf.soma.job.api.model.Error;
import br.pucrio.tecgraf.soma.job.api.model.JobResponse;
import br.pucrio.tecgraf.soma.job.api.model.NewComment;

import java.util.Map;
import java.util.List;
import br.pucrio.tecgraf.soma.job.api.NotFoundException;

import java.io.InputStream;

import org.glassfish.jersey.media.multipart.FormDataParam;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;

import javax.servlet.ServletConfig;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.*;
import javax.validation.constraints.*;
import javax.validation.Valid;

@Path("/jobs/history")


@io.swagger.annotations.Api(description = "the jobs API")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJerseyServerCodegen", date = "2023-09-08T13:35:35.875Z[Etc/UTC]")
public class JobsApi  {
   private final JobsApiService delegate;

   public JobsApi(@Context ServletConfig servletContext) {
      JobsApiService delegate = null;

      if (servletContext != null) {
         String implClass = servletContext.getInitParameter("JobsApi.implementation");
         if (implClass != null && !"".equals(implClass.trim())) {
            try {
               delegate = (JobsApiService) Class.forName(implClass).newInstance();
            } catch (Exception e) {
               throw new RuntimeException(e);
            }
         }
      }

      if (delegate == null) {
         delegate = JobsApiServiceFactory.getJobsApi();
      }

      this.delegate = delegate;
   }

    @javax.ws.rs.GET
    @Path("/algorithms")
    
    @Produces({ "application/json;", "application/json" })
    @io.swagger.annotations.ApiOperation(value = "Fetch list of all distinct algorithms used by the filtered jobs.", notes = "This endpoint lists all distinct algorithms used by the filtered jobs.", response = AlgorithmResponse.class, tags={ "Algorithms", })
    @io.swagger.annotations.ApiResponses(value = {
        @io.swagger.annotations.ApiResponse(code = 200, message = "Successful operation.", response = AlgorithmResponse.class),
        @io.swagger.annotations.ApiResponse(code = 403, message = "if the authenticated user does not have permission to access the project.", response = Error.class)
    })
    public Response jobsHistoryAlgorithmsGet(@ApiParam(value = "The query in RSQL format.") @QueryParam("q")  String q,@ApiParam(value = "The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam("locale")  String locale,@Context SecurityContext securityContext)
    throws NotFoundException {
        return delegate.jobsHistoryAlgorithmsGet(q, locale, securityContext);
    }
    @javax.ws.rs.DELETE
    
    
    
    @io.swagger.annotations.ApiOperation(value = "Archive a job execution.", notes = "This endpoint archives the job execution, removing from the list of searchable jobs.", response = Void.class, tags={ "Jobs", })
    @io.swagger.annotations.ApiResponses(value = {
        @io.swagger.annotations.ApiResponse(code = 204, message = "Successful operation.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 403, message = "if the authenticated user is not authorized to archive the job. Only the job owner or the administrator can archive a job.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 500, message = "Processing error occurred during the job archive operation.", response = Void.class)
    })
    public Response jobsHistoryDelete(@ApiParam(value = "The IDs of the jobs to be archived.", required = true) @QueryParam("jobIds") @NotNull @Valid  List<String> jobIds,@ApiParam(value = "The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam("locale")  String locale,@Context SecurityContext securityContext)
    throws NotFoundException {
        return delegate.jobsHistoryDelete(jobIds, locale, securityContext);
    }
    @javax.ws.rs.GET
    
    
    @Produces({ "application/json;", "application/json" })
    @io.swagger.annotations.ApiOperation(value = "Fetch filtered list of jobs from view job_view.", notes = "This endpoint list all jobs that match the parameters criteria", response = JobResponse.class, tags={ "Jobs", })
    @io.swagger.annotations.ApiResponses(value = {
        @io.swagger.annotations.ApiResponse(code = 200, message = "Successful operation.", response = JobResponse.class),
        @io.swagger.annotations.ApiResponse(code = 403, message = "if the authenticated user does not have permission to access the project.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 400, message = "bad parameters. The error code are: <br> 1. If a invalid limit was used 2. If a invalid offset was used 3. If a invalid sort was used ", response = Error.class)
    })
    public Response jobsHistoryGet(@ApiParam(value = "The query in RSQL format.") @QueryParam("q")  String q,@ApiParam(value = "The zero based position of the first item to retrieve") @QueryParam("offset")  Integer offset,@ApiParam(value = "The number of items to retrieve") @QueryParam("limit")  Integer limit,@ApiParam(value = "Parameter indicating the sorting direction of the results") @QueryParam("asc")  Boolean asc,@ApiParam(value = "Attribute that should be used to sort the results") @QueryParam("attr")  String attr,@ApiParam(value = "Return jobs in the same group as a single entry.", defaultValue = "false") @DefaultValue("false") @QueryParam("grouped")  Boolean grouped,@ApiParam(value = "The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam("locale")  String locale,@Context SecurityContext securityContext)
    throws NotFoundException {
        return delegate.jobsHistoryGet(q, offset, limit, asc, attr, grouped, locale, securityContext);
    }
    @javax.ws.rs.PUT
    @Path("/{jobId}/comment")
    @Consumes({ "application/json" })
    
    @io.swagger.annotations.ApiOperation(value = "Changes a job comment.", notes = "This endpoint edits a job comment.", response = Void.class, tags={ "Jobs", })
    @io.swagger.annotations.ApiResponses(value = {
        @io.swagger.annotations.ApiResponse(code = 204, message = "Successful operation.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 400, message = "Missing body parameter(s).", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 401, message = "No authorization token.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 403, message = "If the authenticated user is not authorized to edit the job comment. Only the job owner or the administrator can edit a job comment.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 404, message = "Job not found.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 500, message = "Processing error occurred during the job edit operation.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 503, message = "Server is currently unable to handle the request.", response = Void.class)
    })
    public Response jobsHistoryJobIdCommentPut(@ApiParam(value = "The ID of the job to be edited.", required = true) @PathParam("jobId") @NotNull  String jobId,@ApiParam(value = "The comment to be added to the job.", required = true) @NotNull @Valid  NewComment newComment,@ApiParam(value = "The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam("locale")  String locale,@Context SecurityContext securityContext)
    throws NotFoundException {
        return delegate.jobsHistoryJobIdCommentPut(jobId, newComment, locale, securityContext);
    }
}
