package br.pucrio.tecgraf.soma.job.application.service;

import javax.transaction.Transactional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import br.pucrio.tecgraf.soma.job.domain.model.Replica;
import br.pucrio.tecgraf.soma.job.domain.model.ReplicaJob;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository.ReplicaRepository;

@Service
public class ReplicaService {
  @Autowired private ReplicaRepository replicaRepository;

  @Transactional
  public void createReplica(Replica replica) {
    replicaRepository.add(replica);
  }

  @Transactional
  public void updateReplica(Replica replica) {
    replicaRepository.update(replica);
    replicaRepository.clearEntityManager(); // garante que contexto estará atualizado após o update
  }

  public Replica findReplicaBy(long multiflowId, int lineNumber) {
    return replicaRepository.findBy(multiflowId, lineNumber);
  }

  public ReplicaJob findReplicaJobBy(String replicaJobId) {
    return replicaRepository.findReplicaJobBy(replicaJobId);
  }

  @Transactional
  public Integer getNextReplicaJobVersion(Replica replica) {
    return this.replicaRepository.getNextReplicaJobVersion(replica);
  }
}
