package br.pucrio.tecgraf.soma.job.domain.dto;

import java.util.ArrayList;
import java.util.List;

import org.modelmapper.AbstractConverter;
import org.modelmapper.ModelMapper;
import org.modelmapper.TypeMap;

import br.pucrio.tecgraf.soma.job.api.model.JobDependency;
import br.pucrio.tecgraf.soma.job.domain.model.Job;

public class JobMapper {

    private static JobMapper instance;
    private final ModelMapper modelMapper;
    private final TypeMap<Job, br.pucrio.tecgraf.soma.job.api.model.Job> typeMap;

    private JobMapper() {
        modelMapper = new ModelMapper();
        typeMap = modelMapper.createTypeMap(Job.class, br.pucrio.tecgraf.soma.job.api.model.Job.class);
        typeMap.addMappings(
                jobMapper
                -> jobMapper
                        .using(new JobDependencyConverter())
                        .map(Job::getJobDependencies, br.pucrio.tecgraf.soma.job.api.model.Job::setJobDependencies));
        typeMap.addMappings(jobMapper -> jobMapper.skip(br.pucrio.tecgraf.soma.job.api.model.Job::setIsGroup)); // setado manualmente
        typeMap.addMappings(jobMapper -> jobMapper.skip(br.pucrio.tecgraf.soma.job.api.model.Job::setSubmissionMachines)); // não usado
        typeMap.addMappings(jobMapper -> jobMapper.skip(br.pucrio.tecgraf.soma.job.api.model.Job::setNumberOfAttempts)); // não usado

        modelMapper.validate();
    }

    private class JobDependencyConverter extends
            AbstractConverter<List<br.pucrio.tecgraf.soma.job.domain.model.JobDependency>, List<JobDependency>> {

        @Override
        public List<JobDependency> convert(List<br.pucrio.tecgraf.soma.job.domain.model.JobDependency> dependencies) {
            List<JobDependency> apiDependecies = new ArrayList<>(dependencies.size());
            for (br.pucrio.tecgraf.soma.job.domain.model.JobDependency jobDependency : dependencies) {
                JobDependency dependency = new JobDependency();
                dependency.setJobId(jobDependency.getJobDependencyRaw());
                dependency.setIsValid(jobDependency.isValid());
                apiDependecies.add(dependency);
            }
            return apiDependecies;
        }
    }

    public static JobMapper getInstance() {
        if (instance == null) {
            instance = new JobMapper();
        }
        return instance;
    }

    public br.pucrio.tecgraf.soma.job.api.model.Job map(Job modelJob) {
        return modelMapper.map(modelJob, br.pucrio.tecgraf.soma.job.api.model.Job.class);
    }
}
