/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.logservice.health;

import java.io.File;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public class ReadnessProbeHealthCheck
implements HealthCheck {
    @ConfigProperty(name="application.basedir")
    public String baseDir;

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder responseBuilder = HealthCheckResponse.named((String)"Directory read health check");
        try {
            if (!this.isDirectoryReadable()) {
                responseBuilder.down().withData("error", "basedir is not readable!");
            } else {
                responseBuilder.up();
            }
        }
        catch (SecurityException e) {
            responseBuilder.down().withData("error", e.getMessage());
        }
        return responseBuilder.build();
    }

    private boolean isDirectoryReadable() {
        File baseDirAsFile = new File(this.baseDir);
        return baseDirAsFile.exists() && baseDirAsFile.isDirectory() && baseDirAsFile.canRead();
    }
}

