/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.websocketnotifier.application.endpoint;

import br.pucrio.tecgraf.soma.websocketnotifier.application.configuration.WebSocketConfig;
import br.pucrio.tecgraf.soma.websocketnotifier.infrastructure.persistence.message.KafkaEventReader;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Observable;
import java.util.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventWebSocket
implements Observer {
    private final Logger logger = LoggerFactory.getLogger(EventWebSocket.class);
    private KafkaEventReader kafkaEventReader;
    private WebSocketConfig webSocketConfig;

    @Autowired
    public EventWebSocket(KafkaEventReader kafkaEventReader, WebSocketConfig webSocketConfig) {
        this.kafkaEventReader = kafkaEventReader;
        this.kafkaEventReader.addObserver((Observer)this);
        this.webSocketConfig = webSocketConfig;
    }

    @Override
    public void update(Observable observable, Object arg) {
        try {
            JsonObject eventMessage = new JsonParser().parse(arg.toString()).getAsJsonObject();
            if (eventMessage == null || !eventMessage.has("event") || !eventMessage.has("eventName")) {
                this.logger.warn(" A message out of format arrive in websocket to be send. This message was skiped");
                return;
            }
            this.webSocketConfig.getSocketHandler().sendMessage(eventMessage);
        }
        catch (Throwable err) {
            this.logger.error("Error call update of EventWebSocket", err);
        }
    }
}

