package br.pucrio.tecgraf.soma.websocketnotifier.factory.chain;

import java.util.List;

import com.google.gson.JsonObject;

import br.pucrio.tecgraf.soma.websocketnotifier.application.configuration.SomaWebSocketSession;

public abstract class AbstractChain {
	
	protected AbstractChain successor;
	
	/** 
	 * 
	 * @param event Mensagem a ser tratada 
	 * @return Mensagem após o tratamento do chain
	 * @throws ChainException Exceção gerada caso um chain queria interromper o processo 
	 * e indicar que a mensagem não será enviada. 
	 */
	public abstract HandlerResult handlerRequest(JsonObject event, List<SomaWebSocketSession> sessions) throws ChainException;
	
	public AbstractChain setSuccessor(AbstractChain successor) {
		this.successor = successor;
		return this.successor;
	}
	
	protected HandlerResult next(JsonObject event, List<SomaWebSocketSession> sessions) throws ChainException {
		if( this.successor == null ) {
			return new HandlerResult(event, sessions);
		}
		return this.successor.handlerRequest(event, sessions);
	}
}
