package br.pucrio.tecgraf.soma.websocketnotifier.application.appservice;

import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation.Builder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.util.List;

import br.pucrio.tecgraf.soma.websocketnotifier.application.service.KtableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import br.pucrio.tecgraf.soma.websocketnotifier.application.configuration.Constants;
import br.pucrio.tecgraf.soma.serviceapi.configuration.ServiceConfiguration;

@Service
public class EventAppService {

  private final Logger logger = LoggerFactory.getLogger(EventAppService.class);

  @Autowired
  private ServiceConfiguration config;

  /**
   * Busca os projetos que o usuário tem acesso via API REST do serviço de projetos do CSGrid.
   * @param accessToken o token para autenticação da chamada à API REST.
   * @return a lista de ids dos projetos que o usuário tem acesso.
   */
  public List<String> getUserProjects(String accessToken) throws NotFoundException {
    String csgridBaseURL = config.getValue(Constants.Config.CSGRID_BASE_URL.option.getLongName());
    String csgridProjectsPermissionPath = config.getValue(Constants.Config.CSGRID_PROJECTS_PERMISSION_PATH.option.getLongName());
    Client client = ClientBuilder.newClient();
    WebTarget target = client.target(csgridBaseURL);
    String requestToken = "Bearer " + accessToken;
    Builder requestBuilder = target.path(csgridProjectsPermissionPath).request(MediaType.APPLICATION_JSON).header(HttpHeaders.AUTHORIZATION, requestToken);
    Response response = requestBuilder.get();
      if (response.getStatus() != 200) {
        logger.warn(csgridBaseURL);
        logger.warn(csgridProjectsPermissionPath);
      throw new NotFoundException("Error while trying to retrieve user projects: "
        +  response.getEntity(), response);
    }
    return response.readEntity(new GenericType<List<String>>() {});
  }

}
