package br.pucrio.tecgraf.soma.websocketnotifier.application.configuration;

import java.util.ArrayList;
import java.util.List;

import br.pucrio.tecgraf.soma.websocketnotifier.model.WebsocketNotifierInfo;
import org.springframework.web.socket.WebSocketSession;

public class SomaWebSocketSession {
	private WebSocketSession webSocketSession;
	private List<String> projectIds;
	private List<WebsocketNotifierInfo> websocketNotifierInfoList;

	public SomaWebSocketSession(WebSocketSession webSocketSession) {
		if( webSocketSession == null ) {
			throw new IllegalArgumentException("WebSocketSession is required");
		}
		this.webSocketSession = webSocketSession;		
		this.projectIds = new ArrayList<>();
		this.websocketNotifierInfoList = new ArrayList<>();
	}
	
	public String getId() {
		return this.webSocketSession.getId();
	}
	
	public void addProjectId(String projectId){
		this.projectIds.add(projectId);
	}

	public WebSocketSession getWebSocketSession() {
		return webSocketSession;
	}

	public List<String> getProjectIds() {
		return projectIds;
	}

	public void setProjectIds(List<String> projectIds) {
		this.projectIds = projectIds;
	}

	public List<WebsocketNotifierInfo> getWebsocketNotifierInfoList() {
		return websocketNotifierInfoList;
	}

	public void setWebsocketNotifierInfoList(List<WebsocketNotifierInfo> websocketNotifierInfoList) {
		this.websocketNotifierInfoList = websocketNotifierInfoList;
	}
}
