package br.pucrio.tecgraf.soma.websocketnotifier.application.endpoint;

import java.util.Observable;
import java.util.Observer;

import br.pucrio.tecgraf.soma.websocketnotifier.application.configuration.WebSocketConfig;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import br.pucrio.tecgraf.soma.websocketnotifier.infrastructure.persistence.message.KafkaEventReader;

@Component
public class EventWebSocket implements Observer {

  private final Logger logger = LoggerFactory.getLogger(EventWebSocket.class);
	
  private KafkaEventReader kafkaEventReader;
  private WebSocketConfig webSocketConfig;

  @Autowired
  public EventWebSocket(KafkaEventReader kafkaEventReader, WebSocketConfig webSocketConfig) {
    this.kafkaEventReader = kafkaEventReader;
    this.kafkaEventReader.addObserver(this);
    this.webSocketConfig = webSocketConfig;
  }

	@Override
	public void update(Observable observable, Object arg) {

		try {
			JsonObject eventMessage = (new JsonParser()).parse(arg.toString()).getAsJsonObject();
			if( eventMessage == null || !eventMessage.has("event") || !eventMessage.has("eventName")) {
				logger.warn(" A message out of format arrive in websocket to be send. This message was skiped");
				return;
			}
			this.webSocketConfig.getSocketHandler().sendMessage(eventMessage);
		} catch (Throwable err) {
			logger.error("Error call update of EventWebSocket", err);
		}
		
	}


}
