/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.bcel.classfile.AccessFlags;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.SourceFile;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.BCELComparator;
import org.apache.bcel.util.ClassQueue;
import org.apache.bcel.util.Repository;
import org.apache.bcel.util.SyntheticRepository;

public class JavaClass
extends AccessFlags
implements Cloneable,
Node,
Comparable {
    private String file_name;
    private String package_name;
    private String source_file_name = "<Unknown>";
    private int class_name_index;
    private int superclass_name_index;
    private String class_name;
    private String superclass_name;
    private int major;
    private int minor;
    private ConstantPool constant_pool;
    private int[] interfaces;
    private String[] interface_names;
    private Field[] fields;
    private Method[] methods;
    private Attribute[] attributes;
    private byte source = 1;
    public static final byte HEAP = 1;
    public static final byte FILE = 2;
    public static final byte ZIP = 3;
    static boolean debug = false;
    static char sep = (char)47;
    static int populationCount = 0;
    static int maxPopulationCount = 0;
    static int totalCreated = 0;
    static HashMap<String, Integer> freqCount;
    static HashMap<String, Integer> stackCount;
    private static final boolean TRACE_ALLOCATIONS = false;
    private static BCELComparator _cmp;
    private transient Repository repository = SyntheticRepository.getInstance();

    static {
        _cmp = new BCELComparator(){

            public boolean equals(Object o1, Object o2) {
                JavaClass THIS = (JavaClass)o1;
                JavaClass THAT = (JavaClass)o2;
                return THIS.getClassName().equals(THAT.getClassName());
            }

            public int hashCode(Object o) {
                JavaClass THIS = (JavaClass)o;
                return THIS.getClassName().hashCode();
            }
        };
        debug = Boolean.getBoolean("JavaClass.debug");
        String _sep = System.getProperty("file.separator");
        if (_sep != null) {
            try {
                sep = _sep.charAt(0);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    protected void finalize() {
        --populationCount;
    }

    public JavaClass(int class_name_index, int superclass_name_index, String file_name, int major, int minor, int access_flags, ConstantPool constant_pool, int[] interfaces, Field[] fields, Method[] methods, Attribute[] attributes, byte source) {
        if (interfaces == null) {
            interfaces = new int[]{};
        }
        if (attributes == null) {
            attributes = Attribute.EMPTY_ARRAY;
        }
        if (fields == null) {
            fields = new Field[]{};
        }
        if (methods == null) {
            methods = new Method[]{};
        }
        this.class_name_index = class_name_index;
        this.superclass_name_index = superclass_name_index;
        this.file_name = file_name;
        this.major = major;
        this.minor = minor;
        this.access_flags = access_flags;
        this.constant_pool = constant_pool;
        this.interfaces = interfaces;
        this.fields = fields;
        this.methods = methods;
        this.attributes = attributes;
        this.source = source;
        int i = 0;
        while (i < attributes.length) {
            if (attributes[i] instanceof SourceFile) {
                this.source_file_name = ((SourceFile)attributes[i]).getSourceFileName();
                break;
            }
            ++i;
        }
        this.class_name = constant_pool.getConstantString(class_name_index, (byte)7);
        this.class_name = Utility.compactClassName(this.class_name, false);
        int index = this.class_name.lastIndexOf(46);
        this.package_name = index < 0 ? "" : this.class_name.substring(0, index);
        if (superclass_name_index > 0) {
            this.superclass_name = constant_pool.getConstantString(superclass_name_index, (byte)7);
            this.superclass_name = Utility.compactClassName(this.superclass_name, false);
        } else {
            this.superclass_name = "java.lang.Object";
        }
        this.interface_names = new String[interfaces.length];
        int i2 = 0;
        while (i2 < interfaces.length) {
            String str = constant_pool.getConstantString(interfaces[i2], (byte)7);
            this.interface_names[i2] = Utility.compactClassName(str, false);
            ++i2;
        }
    }

    public JavaClass(int class_name_index, int superclass_name_index, String file_name, int major, int minor, int access_flags, ConstantPool constant_pool, int[] interfaces, Field[] fields, Method[] methods, Attribute[] attributes) {
        this(class_name_index, superclass_name_index, file_name, major, minor, access_flags, constant_pool, interfaces, fields, methods, attributes, 1);
    }

    public void accept(Visitor v) {
        v.visitJavaClass(this);
    }

    static final void Debug(String str) {
        if (debug) {
            System.out.println(str);
        }
    }

    public void dump(File file) throws IOException {
        String parent = file.getParent();
        if (parent != null) {
            File dir = new File(parent);
            dir.mkdirs();
        }
        FilterOutputStream dos = null;
        try {
            dos = new DataOutputStream(new FileOutputStream(file));
            this.dump((DataOutputStream)dos);
        }
        finally {
            if (dos != null) {
                dos.close();
            }
        }
    }

    public void dump(String _file_name) throws IOException {
        this.dump(new File(_file_name));
    }

    public byte[] getBytes() {
        ByteArrayOutputStream s;
        block11: {
            s = new ByteArrayOutputStream();
            DataOutputStream ds = new DataOutputStream(s);
            try {
                try {
                    this.dump(ds);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        ds.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    ds.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
            try {
                ds.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        return s.toByteArray();
    }

    public void dump(OutputStream file) throws IOException {
        this.dump(new DataOutputStream(file));
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeInt(-889275714);
        file.writeShort(this.minor);
        file.writeShort(this.major);
        this.constant_pool.dump(file);
        file.writeShort(this.access_flags);
        file.writeShort(this.class_name_index);
        file.writeShort(this.superclass_name_index);
        file.writeShort(this.interfaces.length);
        int i = 0;
        while (i < this.interfaces.length) {
            file.writeShort(this.interfaces[i]);
            ++i;
        }
        file.writeShort(this.fields.length);
        i = 0;
        while (i < this.fields.length) {
            this.fields[i].dump(file);
            ++i;
        }
        file.writeShort(this.methods.length);
        i = 0;
        while (i < this.methods.length) {
            this.methods[i].dump(file);
            ++i;
        }
        if (this.attributes != null) {
            file.writeShort(this.attributes.length);
            i = 0;
            while (i < this.attributes.length) {
                this.attributes[i].dump(file);
                ++i;
            }
        } else {
            file.writeShort(0);
        }
        file.flush();
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public String getClassName() {
        return this.class_name;
    }

    public String getPackageName() {
        return this.package_name;
    }

    public int getClassNameIndex() {
        return this.class_name_index;
    }

    public ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public String getFileName() {
        return this.file_name;
    }

    public String[] getInterfaceNames() {
        return this.interface_names;
    }

    public int[] getInterfaceIndices() {
        return this.interfaces;
    }

    public int getMajor() {
        return this.major;
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public Method getMethod(java.lang.reflect.Method m) {
        int i = 0;
        while (i < this.methods.length) {
            Method method = this.methods[i];
            if (m.getName().equals(method.getName()) && m.getModifiers() == method.getModifiers() && Type.getSignature(m).equals(method.getSignature())) {
                return method;
            }
            ++i;
        }
        return null;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getSourceFileName() {
        return this.source_file_name;
    }

    public String getSuperclassName() {
        return this.superclass_name;
    }

    public int getSuperclassNameIndex() {
        return this.superclass_name_index;
    }

    public void setAttributes(Attribute[] attributes) {
        this.attributes = attributes;
    }

    public void setClassName(String class_name) {
        this.class_name = class_name;
    }

    public void setClassNameIndex(int class_name_index) {
        this.class_name_index = class_name_index;
    }

    public void setConstantPool(ConstantPool constant_pool) {
        this.constant_pool = constant_pool;
    }

    public void setFields(Field[] fields) {
        this.fields = fields;
    }

    public void setFileName(String file_name) {
        this.file_name = file_name;
    }

    public void setInterfaceNames(String[] interface_names) {
        this.interface_names = interface_names;
    }

    public void setInterfaces(int[] interfaces) {
        this.interfaces = interfaces;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public void setMethods(Method[] methods) {
        this.methods = methods;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public void setSourceFileName(String source_file_name) {
        this.source_file_name = source_file_name;
    }

    public void setSuperclassName(String superclass_name) {
        this.superclass_name = superclass_name;
    }

    public void setSuperclassNameIndex(int superclass_name_index) {
        this.superclass_name_index = superclass_name_index;
    }

    public String toString() {
        int i;
        String access = Utility.accessToString(this.access_flags, true);
        access = access.equals("") ? "" : String.valueOf(access) + " ";
        StringBuffer buf = new StringBuffer(128);
        buf.append(access).append(Utility.classOrInterface(this.access_flags)).append(" ").append(this.class_name).append(" extends ").append(Utility.compactClassName(this.superclass_name, false)).append('\n');
        int size = this.interfaces.length;
        if (size > 0) {
            buf.append("implements\t\t");
            i = 0;
            while (i < size) {
                buf.append(this.interface_names[i]);
                if (i < size - 1) {
                    buf.append(", ");
                }
                ++i;
            }
            buf.append('\n');
        }
        buf.append("filename\t\t").append(this.file_name).append('\n');
        buf.append("compiled from\t\t").append(this.source_file_name).append('\n');
        buf.append("compiler version\t").append(this.major).append(".").append(this.minor).append('\n');
        buf.append("access flags\t\t").append(this.access_flags).append('\n');
        buf.append("constant pool\t\t").append(this.constant_pool.getLength()).append(" entries\n");
        buf.append("ACC_SUPER flag\t\t").append(this.isSuper()).append("\n");
        if (this.attributes.length > 0) {
            buf.append("\nAttribute(s):\n");
            i = 0;
            while (i < this.attributes.length) {
                buf.append(JavaClass.indent(this.attributes[i]));
                ++i;
            }
        }
        if (this.fields.length > 0) {
            buf.append("\n").append(this.fields.length).append(" fields:\n");
            i = 0;
            while (i < this.fields.length) {
                buf.append("\t").append(this.fields[i]).append('\n');
                ++i;
            }
        }
        if (this.methods.length > 0) {
            buf.append("\n").append(this.methods.length).append(" methods:\n");
            i = 0;
            while (i < this.methods.length) {
                buf.append("\t").append(this.methods[i]).append('\n');
                ++i;
            }
        }
        return buf.toString();
    }

    private static final String indent(Object obj) {
        StringTokenizer tok = new StringTokenizer(obj.toString(), "\n");
        StringBuffer buf = new StringBuffer();
        while (tok.hasMoreTokens()) {
            buf.append("\t").append(tok.nextToken()).append("\n");
        }
        return buf.toString();
    }

    public JavaClass copy() {
        JavaClass c = null;
        try {
            c = (JavaClass)this.clone();
            c.constant_pool = this.constant_pool.copy();
            c.interfaces = (int[])this.interfaces.clone();
            c.interface_names = (String[])this.interface_names.clone();
            c.fields = new Field[this.fields.length];
            int i = 0;
            while (i < this.fields.length) {
                c.fields[i] = this.fields[i].copy(c.constant_pool);
                ++i;
            }
            c.methods = new Method[this.methods.length];
            i = 0;
            while (i < this.methods.length) {
                c.methods[i] = this.methods[i].copy(c.constant_pool);
                ++i;
            }
            if (this.attributes.length > 0) {
                c.attributes = new Attribute[this.attributes.length];
                i = 0;
                while (i < this.attributes.length) {
                    c.attributes[i] = this.attributes[i].copy(c.constant_pool);
                    ++i;
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return c;
    }

    public final boolean isSuper() {
        return (this.access_flags & 0x20) != 0;
    }

    public final boolean isClass() {
        return (this.access_flags & 0x200) == 0;
    }

    public final byte getSource() {
        return this.source;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public final boolean instanceOf(JavaClass super_class) throws ClassNotFoundException {
        if (this.equals(super_class)) {
            return true;
        }
        JavaClass[] super_classes = this.getSuperClasses();
        int i = 0;
        while (i < super_classes.length) {
            if (super_classes[i].equals(super_class)) {
                return true;
            }
            ++i;
        }
        if (super_class.isInterface()) {
            return this.implementationOf(super_class);
        }
        return false;
    }

    public boolean implementationOf(JavaClass inter) throws ClassNotFoundException {
        if (!inter.isInterface()) {
            throw new IllegalArgumentException(String.valueOf(inter.getClassName()) + " is no interface");
        }
        if (this.equals(inter)) {
            return true;
        }
        JavaClass[] super_interfaces = this.getAllInterfaces();
        int i = 0;
        while (i < super_interfaces.length) {
            if (super_interfaces[i].equals(inter)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public JavaClass getSuperClass() throws ClassNotFoundException {
        if ("java.lang.Object".equals(this.getClassName())) {
            return null;
        }
        return this.repository.loadClass(this.getSuperclassName());
    }

    public JavaClass[] getSuperClasses() throws ClassNotFoundException {
        JavaClass clazz = this;
        ArrayList<JavaClass> allSuperClasses = new ArrayList<JavaClass>();
        clazz = clazz.getSuperClass();
        while (clazz != null) {
            allSuperClasses.add(clazz);
            clazz = clazz.getSuperClass();
        }
        return allSuperClasses.toArray(new JavaClass[allSuperClasses.size()]);
    }

    public JavaClass[] getInterfaces() throws ClassNotFoundException {
        String[] _interfaces = this.getInterfaceNames();
        JavaClass[] classes = new JavaClass[_interfaces.length];
        int i = 0;
        while (i < _interfaces.length) {
            classes[i] = this.repository.loadClass(_interfaces[i]);
            ++i;
        }
        return classes;
    }

    public JavaClass[] getAllInterfaces() throws ClassNotFoundException {
        ClassQueue queue = new ClassQueue();
        TreeSet<JavaClass> allInterfaces = new TreeSet<JavaClass>();
        queue.enqueue(this);
        while (!queue.empty()) {
            JavaClass clazz = queue.dequeue();
            JavaClass souper = clazz.getSuperClass();
            JavaClass[] _interfaces = clazz.getInterfaces();
            if (clazz.isInterface()) {
                allInterfaces.add(clazz);
            } else if (souper != null) {
                queue.enqueue(souper);
            }
            int i = 0;
            while (i < _interfaces.length) {
                queue.enqueue(_interfaces[i]);
                ++i;
            }
        }
        return allInterfaces.toArray(new JavaClass[allInterfaces.size()]);
    }

    public static BCELComparator getComparator() {
        return _cmp;
    }

    public static void setComparator(BCELComparator comparator) {
        _cmp = comparator;
    }

    public boolean equals(Object obj) {
        return _cmp.equals(this, obj);
    }

    public int compareTo(Object obj) {
        return this.getClassName().compareTo(((JavaClass)obj).getClassName());
    }

    public int hashCode() {
        return _cmp.hashCode(this);
    }
}

