/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfStructureBase;
import com.lowagie.text.pdf.PdfStructureTreeRoot;
import com.lowagie.text.pdf.PdfWriter;

public class PdfStructureElement
extends PdfStructureBase {
    private PdfStructureElement parent;
    private PdfStructureTreeRoot top;
    private Integer mcid;
    private boolean hasPageMark = false;

    public PdfStructureElement(PdfStructureElement pdfStructureElement, PdfName pdfName) {
        this.top = pdfStructureElement.top;
        this.init(pdfStructureElement, pdfName);
        this.parent = pdfStructureElement;
        this.put(PdfName.P, pdfStructureElement.getIndRef());
    }

    public PdfStructureElement(PdfStructureElement pdfStructureElement, PdfName pdfName, PdfIndirectReference pdfIndirectReference) {
        this.top = pdfStructureElement.top;
        this.init(pdfStructureElement, pdfName, pdfIndirectReference);
        this.parent = pdfStructureElement;
        this.put(PdfName.P, pdfStructureElement.getIndRef());
    }

    public PdfStructureElement(PdfStructureTreeRoot pdfStructureTreeRoot, PdfName pdfName) {
        this.top = pdfStructureTreeRoot;
        this.init(pdfStructureTreeRoot, pdfName);
        this.put(PdfName.P, pdfStructureTreeRoot.getIndRef());
    }

    public static PdfStructureElement createNextElement(PdfStructureElement pdfStructureElement, PdfName pdfName) {
        PdfStructureElement pdfStructureElement2 = new PdfStructureElement(pdfStructureElement, pdfName);
        pdfStructureElement2.getMCID();
        return pdfStructureElement2;
    }

    public PdfWriter getWriter() {
        return this.top.getWriter();
    }

    private void init(PdfStructureBase pdfStructureBase, PdfName pdfName) {
        this.init(pdfStructureBase, pdfName, this.getWriter().getPdfIndirectReference());
    }

    private void init(PdfStructureBase pdfStructureBase, PdfName pdfName, PdfIndirectReference pdfIndirectReference) {
        pdfStructureBase.addKid(this);
        if (pdfName != null) {
            this.put(PdfName.S, pdfName);
        }
        this.setIndRef(pdfIndirectReference);
    }

    public PdfDictionary getParent() {
        return this.parent;
    }

    public int getMCID() {
        this.checkKids();
        if (this.mcid == null) {
            this.mcid = new Integer(this.top.getNextMCID());
        }
        return this.mcid;
    }

    public void setMCID(int n) {
        this.checkKids();
        if (this.mcid != null) {
            throw new RuntimeException("this element already has an MCID");
        }
        this.mcid = new Integer(n);
    }

    public void setMarkedContent(PdfIndirectReference pdfIndirectReference) {
        this.checkKids();
        if (this.contains(PdfName.K)) {
            PdfArray pdfArray = null;
            PdfObject pdfObject = this.get(PdfName.K);
            if (pdfObject == null || pdfObject.isNumber()) {
                pdfArray = new PdfArray();
                if (pdfObject != null) {
                    pdfArray.add(pdfObject);
                }
                this.put(PdfName.K, pdfArray);
            } else if (pdfObject.isArray()) {
                pdfArray = (PdfArray)pdfObject;
            } else {
                throw new IllegalArgumentException("Unknown object at /K " + pdfObject.getClass().toString());
            }
            pdfArray.add(new PdfStructureMC(this.getMCID(), pdfIndirectReference));
        } else {
            this.put(PdfName.K, new PdfNumber(this.getMCID()));
            this.put(PdfName.PG, pdfIndirectReference);
        }
    }

    public void setMarkedObject(PdfIndirectReference pdfIndirectReference, PdfIndirectReference pdfIndirectReference2) {
        this.checkKids();
        if (pdfIndirectReference == null) {
            throw new NullPointerException("object reference must be valid");
        }
        PdfStructureObj pdfStructureObj = new PdfStructureObj(pdfIndirectReference, pdfIndirectReference2);
        this.put(PdfName.K, pdfStructureObj);
        this.setObjMark();
    }

    void setPageMark(int n) {
        this.checkKids();
        if (!this.hasPageMark) {
            this.mcid = new Integer(this.top.setPageMark(n, this.getIndRef()));
            this.hasPageMark = true;
        }
    }

    private void setObjMark() {
        this.top.setObjMark(this.getMCID(), this.getIndRef());
    }

    private void checkKids() {
        if (this.kids != null) {
            throw new IllegalArgumentException("This structure element already has children");
        }
    }

    class PdfStructureObj
    extends PdfDictionary {
        public PdfStructureObj(PdfIndirectReference pdfIndirectReference, PdfIndirectReference pdfIndirectReference2) {
            super(PdfName.OBJR);
            this.put(PdfName.OBJ, pdfIndirectReference);
            if (pdfIndirectReference2 != null) {
                this.put(PdfName.PG, pdfIndirectReference2);
            }
        }
    }

    class PdfStructureMC
    extends PdfDictionary {
        public PdfStructureMC(int n, PdfIndirectReference pdfIndirectReference) {
            super(PdfName.MCR);
            this.put(PdfName.MCID, new PdfNumber(n));
            if (pdfIndirectReference != null) {
                this.put(PdfName.PG, pdfIndirectReference);
            }
        }
    }
}

