/*
 * Decompiled with CFR 0.152.
 */
package org.nsclient4j.jmx.dynamic;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.nsclient4j.NSClient4JException;
import org.nsclient4j.NSClient4j;
import org.nsclient4j.jmx.dynamic.Counter;
import org.nsclient4j.xml.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NSClient4JDynamicService
extends TimerTask
implements DynamicMBean,
NotificationListener,
MBeanRegistration {
    protected String hostName = null;
    protected long frequency = 5000L;
    protected Map counters = new HashMap();
    protected Logger log = null;
    protected MBeanOperationInfo[] operations = new MBeanOperationInfo[2];
    protected NSClient4j client = null;
    protected int hostPort = 1248;
    protected String nsPassword = "None";
    protected boolean up = false;
    protected List attributes = new ArrayList();
    protected ObjectName objectName = null;
    protected MBeanServer server = null;
    protected Integer timerId = null;
    protected String timerObjectName = null;

    public NSClient4JDynamicService(String hostName, long frequency, String timerName) throws Exception {
        this.log = Logger.getLogger(this.getClass());
        this.hostName = hostName;
        this.frequency = frequency;
        this.timerObjectName = timerName;
        try {
            this.operations[0] = new MBeanOperationInfo("Start The NSClient4j Dynamic Service", this.getClass().getMethod("start", new Class[0]));
            this.operations[1] = new MBeanOperationInfo("Stop The NSClient4j Dynamic Service", this.getClass().getMethod("stop", new Class[0]));
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception Initializing NSClient4JDynamicService", ex);
        }
        this.attributes.add(new MBeanAttributeInfo("Counter", "org.w3c.dom.Element", "XML NSClient4J Configuration", true, true, false));
        this.log.info((Object)("Instantiated " + this.getClass().getName()));
    }

    public NSClient4JDynamicService(String hostName, long frequency, String configURL, String timerName) throws Exception {
        this(hostName, frequency, timerName);
        try {
            Document configDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new URL(configURL).openStream());
            this.setCounter(configDoc.getDocumentElement());
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception Initializing NSClient4JDynamicService", ex);
        }
    }

    public void run() {
        Iterator iterator = this.counters.values().iterator();
        while (iterator.hasNext()) {
            Counter counter = (Counter)iterator.next();
            try {
                counter.setResult(this.client.getPerfMonCounter(counter.getCode()));
                this.log.debug((Object)("Read Counter " + counter.getCode() + " from " + this.hostName + ":" + counter.getResult()));
            }
            catch (Exception ex) {
                this.log.error((Object)("Exception Reading Counter " + counter.getCode() + " from " + this.hostName), (Throwable)ex);
            }
        }
    }

    public void setCounter(Element counterNodes) throws ClassNotFoundException, NoSuchMethodException {
        if (counterNodes != null) {
            Iterator counterIterator = XMLHelper.getChildNodesByName(counterNodes, "counter", false).iterator();
            while (counterIterator.hasNext()) {
                Node counterNode = (Node)counterIterator.next();
                String code = XMLHelper.getAttributeValueByName(counterNode.getAttributes(), "code");
                String name = XMLHelper.getAttributeValueByName(counterNode.getAttributes(), "name");
                String description = XMLHelper.getAttributeValueByName(counterNode.getAttributes(), "description");
                String type = XMLHelper.getAttributeValueByName(counterNode.getAttributes(), "type");
                Counter counter = new Counter(name, code, type, description);
                this.counters.put(name, counter);
            }
        }
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Counter counter = (Counter)this.counters.get(attribute);
        if (counter == null) {
            throw new AttributeNotFoundException("Attribute " + attribute + " Not Found");
        }
        Object result = counter.getResult();
        if (result == null) {
            String err = "Counter " + attribute + " Not Initialized Yet";
            MBeanException mbe = new MBeanException(new Exception(err), err);
            this.log.warn((Object)err, (Throwable)mbe);
            throw mbe;
        }
        return result;
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList aList = new AttributeList();
        for (int i = 0; i < attributes.length; ++i) {
            try {
                aList.add(new Attribute(attributes[i], this.getAttribute(attributes[i])));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return aList;
    }

    public MBeanInfo getMBeanInfo() {
        try {
            MBeanInfo mbeanInfo = null;
            MBeanAttributeInfo[] mAttrInfo = new MBeanAttributeInfo[this.counters.size() + this.attributes.size()];
            Iterator<Object> cntrs = this.counters.values().iterator();
            int cnt = 0;
            while (cntrs.hasNext()) {
                mAttrInfo[cnt] = ((Counter)cntrs.next()).getMbeanAttrInfo();
                ++cnt;
            }
            cntrs = this.attributes.iterator();
            while (cntrs.hasNext()) {
                mAttrInfo[cnt] = (MBeanAttributeInfo)cntrs.next();
                ++cnt;
            }
            mbeanInfo = new MBeanInfo(this.getClass().getName(), "NSClient4j Dynamic Service", mAttrInfo, new MBeanConstructorInfo[0], this.operations, new MBeanNotificationInfo[0]);
            return mbeanInfo;
        }
        catch (Exception ex) {
            this.log.error((Object)"Exception Generating MBeanInfo", (Throwable)ex);
            return null;
        }
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try {
            if ("start".equals(actionName)) {
                this.start();
                return null;
            }
            if ("stop".equals(actionName)) {
                this.stop();
                return null;
            }
            String err = "Requested Method Not Found:" + actionName;
            throw new MBeanException(new Exception(err), err);
        }
        catch (Exception e) {
            this.log.error((Object)("Exception Invoking Action:" + actionName), (Throwable)e);
            throw new MBeanException(e, "Exception Invoking Action:" + actionName);
        }
    }

    public void start() throws Exception {
        try {
            this.log.info((Object)"\n\t============================================\n\tStarting NSClient4jService\n\t============================================");
            try {
                this.client = new NSClient4j(this.hostName, this.hostPort, this.nsPassword);
                this.schedulePolling(this.frequency, this.timerObjectName);
                this.up = true;
                this.log.info((Object)("Connected to Host:" + this.client.getHostName() + "\t Up Since " + this.client.getUpTimeDate()));
            }
            catch (NSClient4JException ex) {
                this.log.error((Object)"Failed to Create NSClient4j Adaptor", (Throwable)ex);
                throw new Exception("Failed to Create NSClient4j Adaptor", ex);
            }
            this.log.info((Object)"\n\t============================================\n\tStarted NSClient4jService\n\t============================================");
        }
        catch (Exception ex) {
            throw new MBeanException(ex, "Exception Starting Service");
        }
    }

    public void stop() {
        this.log.info((Object)"\n\t============================================\n\tStopping NSClient4jService\n\t============================================");
        this.log.info((Object)"Closing Client.....");
        try {
            this.up = false;
            this.unSchedulePolling(this.timerObjectName);
            this.client.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.log.info((Object)"Client Closed.");
        this.log.info((Object)"\n\t============================================\n\tStopped NSClient4jService\n\t============================================");
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute.getName().equals("Counter")) {
            try {
                this.setCounter((Element)attribute.getValue());
            }
            catch (Exception e) {
                this.log.error((Object)"Exception Setting Counter Attribute", (Throwable)e);
                throw new InvalidAttributeValueException("Exception Setting Counter Attribute:" + e);
            }
        }
        try {
            Method method = this.getClass().getMethod("set" + attribute.getName(), attribute.getValue().getClass());
            method.invoke((Object)this, attribute.getValue());
        }
        catch (Exception ex) {
            this.log.error((Object)("Exception Invoking set" + attribute.getName()), (Throwable)ex);
            throw new ReflectionException(ex, "Exception Invoking set" + attribute.getName());
        }
    }

    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    protected void schedulePolling(long frequency, String timerName) throws Exception {
        ObjectName timerMBean = new ObjectName(timerName);
        if (!((Boolean)this.server.getAttribute(timerMBean, "Active")).booleanValue()) {
            this.server.invoke(timerMBean, "start", new Object[0], new String[0]);
        }
        this.timerId = (Integer)this.server.invoke(timerMBean, "addNotification", new Object[]{"nsclient4j.poll.schedule." + this.objectName.toString(), "run", null, new Date(), new Long(frequency)}, new String[]{"java.lang.String", "java.lang.String", "java.lang.Object", "java.util.Date", "long"});
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType("nsclient4j.poll.schedule." + this.objectName.toString());
        this.server.addNotificationListener(timerMBean, this, (NotificationFilter)filter, null);
    }

    protected void unSchedulePolling(String timerName) {
        try {
            ObjectName timerMBean = new ObjectName(timerName);
            this.server.invoke(timerMBean, "removeNotification", new Object[]{this.timerId}, new String[]{"java.lang.Integer"});
        }
        catch (Exception ex) {
            this.log.error((Object)"Exception UnSchedulling Polling", (Throwable)ex);
        }
    }

    public void handleNotification(Notification notification, Object handback) {
        this.run();
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.objectName = name;
        return this.objectName;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }
}

