/*
 * Decompiled with CFR 0.152.
 */
package org.nsclient4j.xml;

import java.util.ArrayList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLHelper {
    public static String getAttributeValueByName(NamedNodeMap nnm, String name) {
        for (int i = 0; i < nnm.getLength(); ++i) {
            Attr attr = (Attr)nnm.item(i);
            if (!attr.getName().equalsIgnoreCase(name)) continue;
            return attr.getValue();
        }
        return null;
    }

    public static boolean getAttributeBooleanByName(NamedNodeMap nnm, String name) throws RuntimeException {
        for (int i = 0; i < nnm.getLength(); ++i) {
            Attr attr = (Attr)nnm.item(i);
            if (!attr.getName().equalsIgnoreCase(name)) continue;
            String tmp = attr.getValue().toLowerCase();
            if (tmp.equalsIgnoreCase("true")) {
                return true;
            }
            if (tmp.equalsIgnoreCase("false")) {
                return false;
            }
            throw new RuntimeException("Attribute " + name + " value not boolean:" + tmp);
        }
        throw new RuntimeException("Attribute " + name + " not found.");
    }

    public static Node getChildNodeByName(Element element, String name, boolean caseSensitive) {
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!(caseSensitive ? node.getNodeName().equals(name) : node.getNodeName().equalsIgnoreCase(name))) continue;
            return node;
        }
        return null;
    }

    public static Node getChildNodeByName(Node element, String name, boolean caseSensitive) {
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!(caseSensitive ? node.getNodeName().equals(name) : node.getNodeName().equalsIgnoreCase(name))) continue;
            return node;
        }
        return null;
    }

    public static ArrayList getChildNodesByName(Node element, String name, boolean caseSensitive) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (caseSensitive) {
                if (!node.getNodeName().equals(name)) continue;
                nodes.add(node);
                continue;
            }
            if (!node.getNodeName().equalsIgnoreCase(name)) continue;
            nodes.add(node);
        }
        return nodes;
    }
}

