/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el;

import de.odysseus.el.ExpressionFactoryImpl;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanELResolverTec
extends ELResolver {
    private final boolean readOnly;
    private final ConcurrentHashMap<Class<?>, BeanProperties> cache;
    private ExpressionFactory defaultFactory;

    private static Method findPublicAccessibleMethod(Method method) {
        if (method == null || !Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        if (method.isAccessible() || Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            return method;
        }
        for (Class<?> cls : method.getDeclaringClass().getInterfaces()) {
            Method mth = null;
            try {
                mth = BeanELResolverTec.findPublicAccessibleMethod(cls.getMethod(method.getName(), method.getParameterTypes()));
                if (mth == null) continue;
                return mth;
            }
            catch (NoSuchMethodException ignore) {
                // empty catch block
            }
        }
        Class<?> cls = method.getDeclaringClass().getSuperclass();
        if (cls != null) {
            Method mth = null;
            try {
                mth = BeanELResolverTec.findPublicAccessibleMethod(cls.getMethod(method.getName(), method.getParameterTypes()));
                if (mth != null) {
                    return mth;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Method findAccessibleMethod(Method method) {
        Method result = BeanELResolverTec.findPublicAccessibleMethod(method);
        if (result == null && method != null && Modifier.isPublic(method.getModifiers())) {
            result = method;
            try {
                method.setAccessible(true);
            }
            catch (SecurityException e) {
                result = null;
            }
        }
        return result;
    }

    public BeanELResolverTec() {
        this(false);
    }

    public BeanELResolverTec(boolean readOnly) {
        this.readOnly = readOnly;
        this.cache = new ConcurrentHashMap();
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return this.isResolvable(base) ? Object.class : null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (this.isResolvable(base)) {
            PropertyDescriptor[] properties;
            try {
                properties = Introspector.getBeanInfo(base.getClass()).getPropertyDescriptors();
            }
            catch (IntrospectionException e) {
                return Collections.emptyList().iterator();
            }
            return new Iterator<FeatureDescriptor>(){
                int next = 0;

                @Override
                public boolean hasNext() {
                    return properties != null && this.next < properties.length;
                }

                @Override
                public FeatureDescriptor next() {
                    PropertyDescriptor property = properties[this.next++];
                    FeatureDescriptor feature = new FeatureDescriptor();
                    feature.setDisplayName(property.getDisplayName());
                    feature.setName(property.getName());
                    feature.setShortDescription(property.getShortDescription());
                    feature.setExpert(property.isExpert());
                    feature.setHidden(property.isHidden());
                    feature.setPreferred(property.isPreferred());
                    feature.setValue("type", property.getPropertyType());
                    feature.setValue("resolvableAtDesignTime", true);
                    return feature;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("cannot remove");
                }
            };
        }
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        Class<?> result = null;
        if (this.isResolvable(base)) {
            result = this.toBeanProperty(base, property).getPropertyType();
            context.setPropertyResolved(true);
        }
        return result;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object result = null;
        if (this.isResolvable(base)) {
            Method method = this.toBeanProperty(base, property).getReadMethod();
            if (method == null) {
                throw new PropertyNotFoundException("Cannot read property " + property);
            }
            try {
                result = method.invoke(base, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw new ELException(e.getCause());
            }
            catch (Exception e) {
                throw new ELException((Throwable)e);
            }
            context.setPropertyResolved(true);
        }
        return result;
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        boolean result = this.readOnly;
        if (this.isResolvable(base)) {
            result |= this.toBeanProperty(base, property).isReadOnly();
            context.setPropertyResolved(true);
        }
        return result;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.isResolvable(base)) {
            if (this.readOnly) {
                throw new PropertyNotWritableException("resolver is read-only");
            }
            Method method = this.toBeanProperty(base, property).getWriteMethod();
            if (method == null) {
                throw new PropertyNotWritableException("Cannot write property: " + property);
            }
            try {
                method.invoke(base, value);
            }
            catch (InvocationTargetException e) {
                throw new ELException("Cannot write property: " + property, e.getCause());
            }
            catch (IllegalArgumentException e) {
                throw new ELException("Cannot write property: " + property, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new PropertyNotWritableException("Cannot write property: " + property, (Throwable)e);
            }
            context.setPropertyResolved(true);
        }
    }

    public Object invoke(ELContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object result = null;
        if (this.isResolvable(base)) {
            String name;
            Method target;
            if (params == null) {
                params = new Object[]{};
            }
            if ((target = this.findMethod(base, name = method.toString(), paramTypes, params.length)) == null) {
                throw new MethodNotFoundException("Cannot find method " + name + " with " + params.length + " parameters in " + base.getClass());
            }
            try {
                result = target.invoke(base, this.coerceParams(this.getExpressionFactory(context), target, params));
            }
            catch (InvocationTargetException e) {
                throw new ELException(e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new ELException((Throwable)e);
            }
            context.setPropertyResolved(true);
        }
        return result;
    }

    private Method findMethod(Object base, String name, Class<?>[] types, int paramCount) {
        if (types != null) {
            try {
                return BeanELResolverTec.findAccessibleMethod(base.getClass().getMethod(name, types));
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        Method varArgsMethod = null;
        for (Method method : base.getClass().getMethods()) {
            if (!method.getName().equals(name)) continue;
            int formalParamCount = method.getParameterTypes().length;
            if (method.isVarArgs() && paramCount >= formalParamCount - 1) {
                varArgsMethod = method;
                continue;
            }
            if (paramCount != formalParamCount) continue;
            return BeanELResolverTec.findAccessibleMethod(method);
        }
        return varArgsMethod == null ? null : BeanELResolverTec.findAccessibleMethod(varArgsMethod);
    }

    private ExpressionFactory getExpressionFactory(ELContext context) {
        Object obj = context.getContext(ExpressionFactory.class);
        if (obj instanceof ExpressionFactory) {
            return (ExpressionFactory)obj;
        }
        if (this.defaultFactory == null) {
            this.defaultFactory = new ExpressionFactoryImpl();
        }
        return this.defaultFactory;
    }

    private Object[] coerceParams(ExpressionFactory factory, Method method, Object[] params) {
        Class<?>[] types = method.getParameterTypes();
        Object[] args = new Object[types.length];
        if (method.isVarArgs()) {
            int varargIndex = types.length - 1;
            if (params.length < varargIndex) {
                throw new ELException("Bad argument count");
            }
            for (int i = 0; i < varargIndex; ++i) {
                this.coerceValue(args, i, factory, params[i], types[i]);
            }
            Class<?> varargType = types[varargIndex].getComponentType();
            int length = params.length - varargIndex;
            Object array = null;
            if (length == 1) {
                Object source = params[varargIndex];
                if (source != null && source.getClass().isArray()) {
                    if (types[varargIndex].isInstance(source)) {
                        array = source;
                    } else {
                        length = Array.getLength(source);
                        array = Array.newInstance(varargType, length);
                        for (int i = 0; i < length; ++i) {
                            this.coerceValue(array, i, factory, Array.get(source, i), varargType);
                        }
                    }
                } else {
                    array = Array.newInstance(varargType, 1);
                    this.coerceValue(array, 0, factory, source, varargType);
                }
            } else {
                array = Array.newInstance(varargType, length);
                for (int i = 0; i < length; ++i) {
                    this.coerceValue(array, i, factory, params[varargIndex + i], varargType);
                }
            }
            args[varargIndex] = array;
        } else {
            if (params.length != args.length) {
                throw new ELException("Bad argument count");
            }
            for (int i = 0; i < args.length; ++i) {
                this.coerceValue(args, i, factory, params[i], types[i]);
            }
        }
        return args;
    }

    private void coerceValue(Object array, int index, ExpressionFactory factory, Object value, Class<?> type) {
        if (value != null || type.isPrimitive()) {
            Array.set(array, index, factory.coerceToType(value, type));
        }
    }

    private final boolean isResolvable(Object base) {
        return base != null;
    }

    private final BeanProperty toBeanProperty(Object base, Object property) {
        BeanProperty beanProperty;
        BeanProperties beanProperties = this.cache.get(base.getClass());
        if (beanProperties == null) {
            BeanProperties newBeanProperties = new BeanProperties(base.getClass());
            beanProperties = this.cache.putIfAbsent(base.getClass(), newBeanProperties);
            if (beanProperties == null) {
                beanProperties = newBeanProperties;
            }
        }
        BeanProperty beanProperty2 = beanProperty = property == null ? null : beanProperties.getBeanProperty(property.toString());
        if (beanProperty == null) {
            throw new PropertyNotFoundException("Could not find property " + property + " in " + base.getClass());
        }
        return beanProperty;
    }

    private final void purgeBeanClasses(ClassLoader loader) {
        Iterator classes = ((ConcurrentHashMap.KeySetView)this.cache.keySet()).iterator();
        while (classes.hasNext()) {
            if (loader != ((Class)classes.next()).getClassLoader()) continue;
            classes.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class BeanProperty {
        private final PropertyDescriptor descriptor;
        private Method readMethod;
        private Method writedMethod;

        public BeanProperty(PropertyDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public Class<?> getPropertyType() {
            return this.descriptor.getPropertyType();
        }

        public Method getReadMethod() {
            if (this.readMethod == null) {
                this.readMethod = BeanELResolverTec.findAccessibleMethod(this.descriptor.getReadMethod());
            }
            return this.readMethod;
        }

        public Method getWriteMethod() {
            if (this.writedMethod == null) {
                this.writedMethod = BeanELResolverTec.findAccessibleMethod(this.descriptor.getWriteMethod());
            }
            return this.writedMethod;
        }

        public boolean isReadOnly() {
            return this.getWriteMethod() == null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class BeanProperties {
        private final Map<String, BeanProperty> map = new HashMap<String, BeanProperty>();

        public BeanProperties(Class<?> baseClass) {
            PropertyDescriptor[] descriptors;
            try {
                descriptors = Introspector.getBeanInfo(baseClass).getPropertyDescriptors();
            }
            catch (IntrospectionException e) {
                throw new ELException((Throwable)e);
            }
            for (PropertyDescriptor descriptor : descriptors) {
                this.map.put(descriptor.getName(), new BeanProperty(descriptor));
            }
        }

        public BeanProperty getBeanProperty(String property) {
            return this.map.get(property);
        }
    }
}

