/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import gnu.regexp.UncheckedRE;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.management.AttributeValueExp;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.StringValueExp;
import javax.management.ValueExp;

class MatchQueryExp
extends QueryEval
implements QueryExp {
    private static final long serialVersionUID = -7156603696948215014L;
    private AttributeValueExp exp;
    private String pattern;
    private transient UncheckedRE re;

    public MatchQueryExp() {
    }

    public MatchQueryExp(AttributeValueExp attr, String string) {
        this.exp = attr;
        this.pattern = string;
        this.generateRegExp();
    }

    public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        ValueExp calcAttr = this.exp.apply(name);
        if (calcAttr instanceof StringValueExp) {
            return this.re.isMatch((Object)calcAttr.toString());
        }
        return false;
    }

    public void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.generateRegExp();
    }

    public String toString() {
        return new String("(" + this.exp.toString() + " matches " + this.pattern.toString() + ")");
    }

    private void generateRegExp() {
        StringBuffer buffer = new StringBuffer();
        char[] chars = this.pattern.toCharArray();
        boolean escaping = false;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\\' && !escaping) {
                escaping = true;
                continue;
            }
            if (chars[i] == '?' && !escaping) {
                buffer.append("(?:.)");
            } else if (chars[i] == '?') {
                buffer.append("\\?");
            } else if (chars[i] == '*' && !escaping) {
                buffer.append("(?:.)*");
            } else if (chars[i] == '*') {
                buffer.append("\\*");
            } else if (chars[i] == '^') {
                buffer.append("\\^");
            } else if (chars[i] == '$') {
                buffer.append("\\$");
            } else if (chars[i] == '\\') {
                buffer.append("\\\\");
            } else if (chars[i] == '.') {
                buffer.append("\\.");
            } else if (chars[i] == '|') {
                buffer.append("\\|");
            } else if (chars[i] == '[' && escaping) {
                buffer.append("\\[");
            } else {
                buffer.append(chars[i]);
            }
            escaping = false;
        }
        if (escaping) {
            buffer.append("\\\\");
        }
        this.re = new UncheckedRE((Object)buffer);
    }
}

