/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.ajax.components;

import java.util.HashMap;
import java.util.Map;
import net.sf.tacos.ajax.AjaxDirectServiceParameter;
import net.sf.tacos.ajax.AjaxFormSupport;
import net.sf.tacos.ajax.AjaxInvocation;
import net.sf.tacos.ajax.AjaxUtils;
import net.sf.tacos.ajax.AjaxWebRequest;
import net.sf.tacos.ajax.components.AjaxFormSupportImpl;
import org.apache.hivemind.Location;
import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IActionListener;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IDirect;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.IScriptProcessor;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.RenderRewoundException;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.engine.ActionServiceParameter;
import org.apache.tapestry.engine.DirectServiceParameter;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.engine.NullWriter;
import org.apache.tapestry.form.FormEventType;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.listener.ListenerInvoker;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.web.WebResponse;

public abstract class AjaxForm
extends AbstractComponent
implements IForm,
IDirect,
AjaxInvocation {
    protected String name;
    protected AjaxFormSupport formSupport;
    protected IRender renderInformalParameters;

    public abstract IScript getScript();

    public abstract AjaxWebRequest getAjaxRequest();

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        this.renderComponentDelegate(writer, cycle);
        if (!this.isRewinding() && !NullWriter.class.isInstance(writer)) {
            Map parmMap = this.constructScriptParameter(cycle);
            PageRenderSupport pageRenderSupport = TapestryUtils.getPageRenderSupport((IRequestCycle)cycle, (IComponent)this);
            this.getScript().execute(cycle, (IScriptProcessor)pageRenderSupport, parmMap);
        }
    }

    public Map constructScriptParameter(IRequestCycle cycle) {
        HashMap<String, String> parmMap = new HashMap<String, String>();
        parmMap.put("formId", this.getName());
        AjaxUtils.putAjaxParameter(this, parmMap, cycle);
        return parmMap;
    }

    public ILink getAjaxLink() {
        String[] updateComponents = new String[]{};
        if (this.getUpdateComponents() != null) {
            updateComponents = this.getUpdateComponents().toArray(new String[this.getUpdateComponents().size()]);
        }
        AjaxDirectServiceParameter dsp = new AjaxDirectServiceParameter((IDirect)this, new Object[0], updateComponents, false);
        return this.getAjaxEngine().getLink(true, (Object)dsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewind(IMarkupWriter writer, IRequestCycle cycle) {
        AjaxWebRequest ar = (AjaxWebRequest)cycle.getAttribute("ajax-request");
        try {
            super.render(writer, cycle);
        }
        finally {
            if (ar != null) {
                cycle.setAttribute("ajax-request", (Object)ar);
            }
        }
    }

    public static IForm get(IRequestCycle cycle) {
        return (IForm)cycle.getAttribute("org.apache.tapestry.Form");
    }

    public boolean isRewinding() {
        if (!this.isRendering()) {
            throw Tapestry.createRenderOnlyPropertyException((IComponent)this, (String)"rewinding");
        }
        return this.formSupport.isRewinding();
    }

    public abstract IEngineService getDirectService();

    public abstract IEngineService getActionService();

    public abstract boolean isDirect();

    public boolean getRequiresSession() {
        return this.isStateful();
    }

    public String getElementId(IFormComponent component) {
        return this.formSupport.getElementId(component, component.getId());
    }

    public String getElementId(IFormComponent component, String baseId) {
        return this.formSupport.getElementId(component, baseId);
    }

    public String getName() {
        return this.name;
    }

    protected void prepareForRender(IRequestCycle cycle) {
        super.prepareForRender(cycle);
        TapestryUtils.storeForm((IRequestCycle)cycle, (IForm)this);
    }

    protected void cleanupAfterRender(IRequestCycle cycle) {
        this.formSupport = null;
        TapestryUtils.removeForm((IRequestCycle)cycle);
        IValidationDelegate delegate = this.getDelegate();
        if (delegate != null) {
            delegate.setFormComponent(null);
        }
        super.cleanupAfterRender(cycle);
    }

    protected void renderComponentDelegate(IMarkupWriter writer, IRequestCycle cycle) {
        String actionId = cycle.getNextActionId();
        this.formSupport = this.newFormSupport(writer, cycle);
        if (this.isRewinding()) {
            String submitType = this.formSupport.rewind();
            IActionListener listener = this.findListener(submitType);
            this.getListenerInvoker().invokeListener(listener, (IComponent)this, cycle);
            throw new RenderRewoundException((Object)this);
        }
        String baseName = this.isDirect() ? this.constructFormNameForDirectService(cycle) : this.constructFormNameForActionService(actionId);
        this.name = baseName + this.getResponse().getNamespace();
        if (this.renderInformalParameters == null) {
            this.renderInformalParameters = new RenderInformalParameters();
        }
        ILink link = this.getLink(cycle, actionId);
        this.formSupport.render(this.getMethod(), this.renderInformalParameters, link, this.getScheme(), this.getPort());
    }

    IActionListener findListener(String mode) {
        IActionListener result = null;
        if (mode.equals("cancel")) {
            result = this.getCancel();
        } else if (mode.equals("refresh")) {
            result = this.getRefresh();
        } else if (!this.getDelegate().getHasErrors()) {
            result = this.getSuccess();
        }
        if (result == null) {
            result = this.getListener();
        }
        return result;
    }

    protected String constructFormNameForActionService(String actionId) {
        return "Form" + actionId;
    }

    private String constructFormNameForDirectService(IRequestCycle cycle) {
        return cycle.getUniqueId(TapestryUtils.convertTapestryIdToNMToken((String)this.getId()));
    }

    protected AjaxFormSupport newFormSupport(IMarkupWriter writer, IRequestCycle cycle) {
        return new AjaxFormSupportImpl(writer, cycle, this.getAjaxRequest(), this);
    }

    public void addEventHandler(FormEventType type, String functionName) {
        this.formSupport.addEventHandler(type, functionName);
    }

    public void trigger(IRequestCycle cycle) {
        cycle.rewindForm((IForm)this);
    }

    private ILink getLink(IRequestCycle cycle, String actionId) {
        if (this.isDirect()) {
            DirectServiceParameter parameter = new DirectServiceParameter((IDirect)this);
            return this.getDirectService().getLink(true, (Object)parameter);
        }
        ActionServiceParameter parameter = new ActionServiceParameter((IComponent)this, actionId);
        return this.getActionService().getLink(true, (Object)parameter);
    }

    public abstract WebResponse getResponse();

    public abstract IValidationDelegate getDelegate();

    public abstract IActionListener getListener();

    public abstract IActionListener getSuccess();

    public abstract IActionListener getCancel();

    public abstract IActionListener getRefresh();

    public abstract String getMethod();

    public abstract boolean isStateful();

    public abstract String getScheme();

    public abstract Integer getPort();

    public void setEncodingType(String encodingType) {
        this.formSupport.setEncodingType(encodingType);
    }

    public void addHiddenValue(String name, String value) {
        this.formSupport.addHiddenValue(name, value);
    }

    public void addHiddenValue(String name, String id, String value) {
        this.formSupport.addHiddenValue(name, id, value);
    }

    public void prerenderField(IMarkupWriter writer, IComponent field, Location location) {
        this.formSupport.prerenderField(writer, field, location);
    }

    public boolean wasPrerendered(IMarkupWriter writer, IComponent field) {
        return this.formSupport.wasPrerendered(writer, field);
    }

    public void addDeferredRunnable(Runnable runnable) {
        this.formSupport.addDeferredRunnable(runnable);
    }

    public abstract ListenerInvoker getListenerInvoker();

    public void registerForFocus(IFormComponent field, int priority) {
        this.formSupport.registerForFocus(field, priority);
    }

    public String getEncodingType() {
        return this.formSupport.getEncodingType();
    }

    protected class RenderInformalParameters
    implements IRender {
        protected RenderInformalParameters() {
        }

        public void render(IMarkupWriter writer, IRequestCycle cycle) {
            AjaxForm.this.renderInformalParameters(writer, cycle);
        }
    }
}

