/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.ajax.components;

import java.util.Collection;
import java.util.Map;
import net.sf.tacos.ajax.components.AbstractSubmit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.HiveMind;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.IScriptProcessor;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.TapestryUtils;

public abstract class AjaxSubmit
extends AbstractSubmit {
    private static final Log log = LogFactory.getLog((Class)AjaxSubmit.class);

    public abstract Collection getUpdateComponents();

    public abstract IScript getScript();

    protected boolean isClicked(IRequestCycle cycle, String name) {
        String value = cycle.getParameter(name);
        if (value == null) {
            value = cycle.getParameter("_tacos_fix_" + name);
        }
        log.debug((Object)("isClicked(" + name + ") with value:" + value));
        return HiveMind.isNonBlank((String)value);
    }

    protected void renderFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        String label;
        writer.beginEmpty("input");
        writer.attribute("type", "submit");
        writer.attribute("name", this.getName());
        if (this.isDisabled()) {
            writer.attribute("disabled", "disabled");
        }
        if ((label = this.getLabel()) != null) {
            writer.attribute("value", label);
        }
        this.renderIdAttribute(writer, cycle);
        this.renderInformalParameters(writer, cycle);
        writer.closeTag();
        if (!this.isDisabled()) {
            Map parmMap = this.constructScriptParameter(cycle);
            PageRenderSupport pageRenderSupport = TapestryUtils.getPageRenderSupport((IRequestCycle)cycle, (IComponent)this);
            this.getScript().execute(cycle, (IScriptProcessor)pageRenderSupport, parmMap);
        }
    }

    public String getComponentId() {
        return this.getClientId();
    }

    public String getHiddenId() {
        return this.getName();
    }

    public boolean isDeferred() {
        return false;
    }

    public abstract String getLabel();
}

