/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.ajax.components;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import net.sf.tacos.ajax.AjaxWebRequest;
import net.sf.tacos.util.ScriptUtils;
import org.apache.hivemind.Resource;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.IScriptProcessor;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.engine.IScriptSource;
import org.apache.tapestry.form.AbstractFormComponent;
import org.apache.tapestry.form.TranslatedField;
import org.apache.tapestry.form.TranslatedFieldSupport;
import org.apache.tapestry.form.ValidatableField;
import org.apache.tapestry.form.ValidatableFieldSupport;
import org.apache.tapestry.form.translator.DateTranslator;
import org.apache.tapestry.valid.ValidatorException;

public abstract class DatePicker
extends AbstractFormComponent
implements TranslatedField {
    private IScript script;
    private static final String SYM_NAME = "name";
    private static final String SYM_FORMNAME = "formName";
    private static final String SYM_MONTHNAMES = "monthNames";
    private static final String SYM_SHORT_MONTHNAMES = "shortMonthNames";
    private static final String SYM_WEEKDAYNAMES = "weekDayNames";
    private static final String SYM_SHORT_WEEKDAYNAMES = "shortWeekDayNames";
    private static final String SYM_FIRSTDAYINWEEK = "firstDayInWeek";
    private static final String SYM_MINDAYSINFIRSTWEEK = "minimalDaysInFirstWeek";
    private static final String SYM_FORMAT = "format";
    private static final String SYM_INCL_WEEK = "includeWeek";
    private static final String SYM_VALUE = "value";
    private static final String SYM_BUTTONONCLICKHANDLER = "buttonOnclickHandler";
    private static final String SYM_AJAX = "ajax";

    public abstract Date getValue();

    public abstract void setValue(Date var1);

    public abstract boolean isDisabled();

    public abstract boolean getIncludeWeek();

    public abstract IAsset getIcon();

    public abstract IScriptSource getScriptSource();

    protected void finishLoad() {
        super.finishLoad();
        IScriptSource source = this.getScriptSource();
        Resource location = this.getSpecification().getSpecificationLocation().getRelativeResource("DatePicker.script");
        this.script = source.getScript(location);
    }

    protected void renderFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        PageRenderSupport pageRenderSupport = TapestryUtils.getPageRenderSupport((IRequestCycle)cycle, (IComponent)this);
        boolean disabled = this.isDisabled();
        DateTranslator translator = (DateTranslator)this.getTranslator();
        Locale locale = this.getPage().getLocale();
        SimpleDateFormat format = translator.getDateFormat(locale);
        DateFormatSymbols dfs = format.getDateFormatSymbols();
        Calendar cal = Calendar.getInstance(locale);
        String name = this.getName();
        String value = this.getTranslatedFieldSupport().format((TranslatedField)this, (Object)this.getValue());
        this.renderDelegatePrefix(writer, cycle);
        writer.beginEmpty("input");
        writer.attribute("type", "text");
        writer.attribute(SYM_NAME, name);
        writer.attribute(SYM_VALUE, value);
        writer.attribute("title", format.toLocalizedPattern());
        if (disabled) {
            writer.attribute("disabled", "disabled");
        }
        this.renderIdAttribute(writer, cycle);
        if (this.getClientId() != null) {
            name = this.getClientId();
        }
        this.renderDelegateAttributes(writer, cycle);
        this.getTranslatedFieldSupport().renderContributions((TranslatedField)this, writer, cycle);
        this.getValidatableFieldSupport().renderContributions((ValidatableField)this, writer, cycle);
        this.renderInformalParameters(writer, cycle);
        writer.printRaw("&nbsp;");
        if (!disabled) {
            writer.begin("span");
            writer.attribute("id", name + "href");
        }
        IAsset icon = this.getIcon();
        writer.beginEmpty("img");
        writer.attribute("src", icon.buildURL());
        writer.attribute("border", 0);
        if (!disabled) {
            writer.end();
        }
        this.renderDelegateSuffix(writer, cycle);
        HashMap<String, Object> symbols = new HashMap<String, Object>();
        symbols.put(SYM_NAME, name);
        symbols.put(SYM_FORMAT, format.toPattern());
        symbols.put(SYM_INCL_WEEK, this.getIncludeWeek() ? Boolean.TRUE : Boolean.FALSE);
        symbols.put(SYM_MONTHNAMES, ScriptUtils.toJsStringArray(dfs.getMonths(), 0, 12));
        symbols.put(SYM_SHORT_MONTHNAMES, ScriptUtils.toJsStringArray(dfs.getShortMonths(), 0, 12));
        symbols.put(SYM_WEEKDAYNAMES, ScriptUtils.toJsStringArray(dfs.getWeekdays(), 1, 8));
        symbols.put(SYM_SHORT_WEEKDAYNAMES, ScriptUtils.toJsStringArray(dfs.getShortWeekdays(), 1, 8));
        symbols.put(SYM_FIRSTDAYINWEEK, new Integer(cal.getFirstDayOfWeek() - 1));
        symbols.put(SYM_MINDAYSINFIRSTWEEK, new Integer(cal.getMinimalDaysInFirstWeek()));
        symbols.put(SYM_FORMNAME, this.getForm().getName());
        symbols.put(SYM_VALUE, this.getValue());
        boolean ajaxReq = this.getAjaxWebRequest().isValidRequest();
        symbols.put(SYM_AJAX, String.valueOf(ajaxReq));
        this.script.execute(cycle, (IScriptProcessor)pageRenderSupport, symbols);
    }

    protected void rewindFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        String value = cycle.getParameter(this.getName());
        try {
            Date date = (Date)this.getTranslatedFieldSupport().parse((TranslatedField)this, value);
            this.getValidatableFieldSupport().validate((ValidatableField)this, writer, cycle, (Object)date);
            this.setValue(date);
        }
        catch (ValidatorException e) {
            this.getForm().getDelegate().record(e);
        }
    }

    public abstract ValidatableFieldSupport getValidatableFieldSupport();

    public abstract TranslatedFieldSupport getTranslatedFieldSupport();

    public abstract AjaxWebRequest getAjaxWebRequest();

    public boolean isRequired() {
        return this.getValidatableFieldSupport().isRequired((ValidatableField)this);
    }
}

