/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.ajax.components;

import java.util.Collection;
import java.util.HashMap;
import net.sf.tacos.ajax.AjaxUtils;
import net.sf.tacos.ajax.AjaxWebRequest;
import net.sf.tacos.ajax.components.AjaxDirectLink;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.IScriptProcessor;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.TapestryUtils;

public abstract class DropTarget
extends BaseComponent {
    private static final Log log = LogFactory.getLog((Class)DropTarget.class);

    public abstract AjaxWebRequest getAjaxWebRequest();

    public abstract IScript getScript();

    public abstract Collection getAcceptsTagType();

    public abstract Object getDragSource();

    public abstract String getDragSourceElement();

    public abstract String getDragSourceClass();

    public abstract String getDragSourceTag();

    public abstract AjaxDirectLink getDragSourceLink();

    public abstract boolean isInsertDragSource();

    public abstract String getOnDragOver();

    public abstract String getOnDragOut();

    public abstract String getOnDrop();

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        writer.begin("div");
        writer.attribute("id", this.getId());
        super.renderInformalParameters(writer, cycle);
        super.renderBody(writer, cycle);
        writer.end();
        HashMap<String, Object> scriptParms = new HashMap<String, Object>();
        scriptParms.put("sourceLinkParms", AjaxUtils.getLinkArguments(this.getDragSourceLink(), true));
        scriptParms.put("dropTargetId", this.getId());
        scriptParms.put("insertDragSource", Boolean.toString(this.isInsertDragSource()));
        if (this.getAjaxWebRequest().isValidRequest()) {
            scriptParms.put("ajax", "true");
        } else {
            scriptParms.put("ajax", "false");
        }
        scriptParms.put("dragSource", this.getDragSource());
        scriptParms.put("dragSourceElement", this.getDragSourceElement());
        scriptParms.put("dragSourceClass", this.getDragSourceClass());
        scriptParms.put("dragSourceTag", this.getDragSourceTag());
        scriptParms.put("onDragOver", this.getOnDragOver());
        scriptParms.put("onDragOut", this.getOnDragOut());
        scriptParms.put("onDrop", this.getOnDrop());
        scriptParms.put("tagTypes", this.getAcceptsTagType());
        PageRenderSupport pageRenderSupport = TapestryUtils.getPageRenderSupport((IRequestCycle)cycle, (IComponent)this);
        this.getScript().execute(cycle, (IScriptProcessor)pageRenderSupport, scriptParms);
    }
}

