/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.ajax.components;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import net.sf.tacos.ajax.AjaxWebRequest;
import net.sf.tacos.ajax.components.PartialRenderBlock;
import net.sf.tacos.model.IKeyProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.bean.EvenOdd;
import org.apache.tapestry.coerce.ValueConverter;
import org.apache.tapestry.components.IPrimaryKeyConverter;
import org.apache.tapestry.engine.NullWriter;
import org.apache.tapestry.form.AbstractFormComponent;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.services.DataSqueezer;
import org.apache.tapestry.services.ExpressionEvaluator;

public abstract class PartialForBean
extends AbstractFormComponent {
    private static final Log log = LogFactory.getLog((Class)PartialForBean.class);
    private static final char DESC_VALUE = 'V';
    private static final char DESC_PRIMARY_KEY = 'P';
    private final RepSource COMPLETE_REP_SOURCE = new CompleteRepSource();
    private final RepSource KEY_EXPRESSION_REP_SOURCE = new KeyExpressionRepSource();
    private Object _value;
    private int _index;
    private boolean _rendering;

    public abstract Object getSource();

    public abstract Object getFullSource();

    public abstract String getElement();

    public abstract String getKeyExpression();

    public abstract IPrimaryKeyConverter getConverter();

    public abstract Object getDefaultValue();

    public abstract boolean getMatch();

    public abstract boolean getVolatile();

    public abstract Iterator getSourceIterator();

    public abstract void setSourceIterator(Iterator var1);

    public abstract Iterator getFullSourceIterator();

    public abstract void setFullSourceIterator(Iterator var1);

    public abstract Map getRepToValueMap();

    public abstract void setRepToValueMap(Map var1);

    public abstract EvenOdd getEvenOdd();

    public abstract IKeyProvider getKeyProvider();

    public abstract DataSqueezer getDataSqueezer();

    public abstract ValueConverter getValueConverter();

    public abstract ExpressionEvaluator getExpressionEvaluator();

    public abstract AjaxWebRequest getAjaxWebRequest();

    public abstract PartialRenderBlock getPartialBlock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        this.setSourceIterator(null);
        IForm form = (IForm)cycle.getAttribute("org.apache.tapestry.Form");
        boolean cycleRewinding = cycle.isRewinding();
        if (cycleRewinding && form != null && !form.isRewinding()) {
            return;
        }
        Iterator dataSource = this.getData(cycle, form);
        if (dataSource == null) {
            return;
        }
        String element = this.getElement();
        AjaxWebRequest ajax = this.getAjaxWebRequest();
        boolean ajaxValid = ajax.isValidRequest();
        IMarkupWriter loopWriter = writer;
        try {
            this._index = 0;
            this._rendering = true;
            while (dataSource.hasNext()) {
                loopWriter = writer;
                this._value = dataSource.next();
                String keyid = this.getKeyId(this._value);
                this.updateOutputParameters();
                if (!(writer instanceof NullWriter) || ajaxValid || cycle.isRewinding()) {
                    if (writer instanceof NullWriter && ajaxValid) {
                        IMarkupWriter partWriter = null;
                        if (ajax.containsComponentId(keyid)) {
                            partWriter = ajax.getResponseBuilder().getComponentWriter(keyid);
                        } else if (this.getPartialBlock() != null) {
                            partWriter = this.getPartialBlock().getPartWriter((Serializable)((Object)keyid));
                        }
                        if (partWriter != null) {
                            loopWriter = partWriter;
                        } else {
                            if (this.getPartialBlock() != null) {
                                this.getPartialBlock().incrementNonRenderBlock();
                                continue;
                            }
                            if (this.getEvenOdd() == null) continue;
                            this.getEvenOdd().getNext();
                            continue;
                        }
                    }
                    if (this.getPartialBlock() != null) {
                        this.getPartialBlock().beforeRenderBody(loopWriter, cycle, (Serializable)((Object)keyid), true);
                    }
                    if (element != null) {
                        loopWriter.begin(element);
                        this.renderInformalParameters(loopWriter, cycle);
                    }
                    this.renderBody(loopWriter, cycle);
                    if (element != null) {
                        loopWriter.end();
                    }
                }
                ++this._index;
            }
        }
        finally {
            this._rendering = false;
            this._value = null;
        }
    }

    protected String getKeyId(Object value) {
        String id = null;
        if (this.getKeyProvider() != null) {
            return this.getKeyProvider().getKey(value).toString();
        }
        Object keyId = this.getPrimaryKeyFromValue(value);
        id = keyId != null ? keyId.toString() : value.toString();
        return id;
    }

    public final Object getValue() {
        if (!this._rendering) {
            throw Tapestry.createRenderOnlyPropertyException((IComponent)this, (String)"value");
        }
        return this._value;
    }

    public int getIndex() {
        if (!this._rendering) {
            throw Tapestry.createRenderOnlyPropertyException((IComponent)this, (String)"index");
        }
        return this._index;
    }

    public boolean isDisabled() {
        return false;
    }

    protected void updateOutputParameters() {
        IBinding valueBinding;
        IBinding indexBinding = this.getBinding("index");
        if (indexBinding != null) {
            indexBinding.setObject((Object)new Integer(this._index));
        }
        if ((valueBinding = this.getBinding("value")) != null) {
            valueBinding.setObject(this._value);
        }
    }

    protected void updatePrimaryKeysParameter(String[] stringReps) {
        IBinding primaryKeysBinding = this.getBinding("primaryKeys");
        if (primaryKeysBinding == null) {
            return;
        }
        DataSqueezer squeezer = this.getDataSqueezer();
        int repsCount = stringReps.length;
        ArrayList<Object> primaryKeys = new ArrayList<Object>(repsCount);
        for (int i = 0; i < stringReps.length; ++i) {
            String rep = stringReps[i];
            if (rep.length() == 0 || rep.charAt(0) != 'P') continue;
            Object primaryKey = squeezer.unsqueeze(rep.substring(1));
            primaryKeys.add(primaryKey);
        }
        primaryKeysBinding.setObject(primaryKeys);
    }

    protected void renderFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
    }

    protected void rewindFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
    }

    private Iterator getData(IRequestCycle cycle, IForm form) {
        if (form == null || this.getVolatile()) {
            return this.getSourceIteratorValue();
        }
        String name = form.getElementId((IFormComponent)this);
        if (cycle.isRewinding()) {
            return this.getStoredData(cycle, name);
        }
        return this.storeSourceData(form, name);
    }

    protected Iterator getStoredData(IRequestCycle cycle, String name) {
        String[] stringReps = cycle.getParameters(name);
        if (stringReps == null) {
            return null;
        }
        this.updatePrimaryKeysParameter(stringReps);
        int valueCount = stringReps.length;
        ArrayList<Object> values = new ArrayList<Object>(valueCount);
        for (int i = 0; i < valueCount; ++i) {
            String rep = stringReps[i];
            Object value = this.getValueFromStringRep(rep);
            values.add(value);
        }
        return values.iterator();
    }

    protected Iterator storeSourceData(IForm form, String name) {
        ArrayList values = new ArrayList();
        Iterator it = this.getSourceIteratorValue();
        while (it.hasNext()) {
            Object value = it.next();
            values.add(value);
            String rep = this.getStringRepFromValue(value);
            form.addHiddenValue(name, rep);
        }
        return values.iterator();
    }

    protected String getStringRepFromValue(Object value) {
        DataSqueezer squeezer = this.getDataSqueezer();
        Object pk = this.getPrimaryKeyFromValue(value);
        String rep = pk != null ? 'P' + squeezer.squeeze(pk) : 'V' + squeezer.squeeze(value);
        return rep;
    }

    protected Object getPrimaryKeyFromValue(Object value) {
        if (value == null) {
            return null;
        }
        Object primaryKey = this.getKeyExpressionFromValue(value);
        if (primaryKey == null) {
            primaryKey = this.getConverterFromValue(value);
        }
        return primaryKey;
    }

    protected Object getKeyExpressionFromValue(Object value) {
        String keyExpression = this.getKeyExpression();
        if (keyExpression == null) {
            return null;
        }
        Object primaryKey = this.getExpressionEvaluator().read(value, keyExpression);
        return primaryKey;
    }

    protected Object getConverterFromValue(Object value) {
        IPrimaryKeyConverter converter = this.getConverter();
        if (converter == null) {
            return null;
        }
        Object primaryKey = converter.getPrimaryKey(value);
        return primaryKey;
    }

    protected Object getValueFromStringRep(String rep) {
        Object value = null;
        DataSqueezer squeezer = this.getDataSqueezer();
        if (rep == null || rep.length() == 0) {
            return this.getDefaultValue();
        }
        boolean match = this.getMatch();
        if (match && (value = this.findValueWithStringRep(rep, this.COMPLETE_REP_SOURCE)) != null) {
            return value;
        }
        char desc = rep.charAt(0);
        String squeezed = rep.substring(1);
        switch (desc) {
            case 'V': {
                value = squeezer.unsqueeze(squeezed);
                break;
            }
            case 'P': {
                IPrimaryKeyConverter converter;
                if (!match && this.getKeyExpression() != null) {
                    value = this.findValueWithStringRep(rep, this.KEY_EXPRESSION_REP_SOURCE);
                }
                if (value != null || (converter = this.getConverter()) == null) break;
                Object pk = squeezer.unsqueeze(squeezed);
                value = converter.getValue(pk);
            }
        }
        if (value == null) {
            value = this.getDefaultValue();
        }
        return value;
    }

    protected Object findValueWithStringRep(String rep, RepSource repSource) {
        Map repToValueMap = this.getRepToValueMap();
        Object value = repToValueMap.get(rep);
        if (value != null) {
            return value;
        }
        Iterator it = this.getSourceIteratorValue();
        value = this.findValueWithStringRepInIterator(rep, repSource, it);
        if (value != null) {
            return value;
        }
        it = this.getFullSourceIteratorValue();
        value = this.findValueWithStringRepInIterator(rep, repSource, it);
        return value;
    }

    protected Object findValueWithStringRepInIterator(String rep, RepSource repSource, Iterator it) {
        Map repToValueMap = this.getRepToValueMap();
        while (it.hasNext()) {
            Object sourceValue = it.next();
            if (sourceValue == null) continue;
            String sourceRep = repSource.getStringRep(sourceValue);
            repToValueMap.put(sourceRep, sourceValue);
            if (!rep.equals(sourceRep)) continue;
            return sourceValue;
        }
        return null;
    }

    protected Iterator getSourceIteratorValue() {
        Iterator it = this.getSourceIterator();
        if (it == null) {
            it = (Iterator)this.getValueConverter().coerceValue(this.getSource(), Iterator.class);
            if (it == null) {
                it = Collections.EMPTY_LIST.iterator();
            }
            this.setSourceIterator(it);
        }
        return it;
    }

    protected Iterator getFullSourceIteratorValue() {
        Iterator it = this.getFullSourceIterator();
        if (it == null) {
            it = (Iterator)this.getValueConverter().coerceValue(this.getFullSource(), Iterator.class);
            if (it == null) {
                it = Collections.EMPTY_LIST.iterator();
            }
            this.setFullSourceIterator(it);
        }
        return it;
    }

    protected boolean getCanTakeFocus() {
        return false;
    }

    public String getClientId() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    protected class KeyExpressionRepSource
    implements RepSource {
        protected KeyExpressionRepSource() {
        }

        public String getStringRep(Object value) {
            Object pk = PartialForBean.this.getKeyExpressionFromValue(value);
            return 'P' + PartialForBean.this.getDataSqueezer().squeeze(pk);
        }
    }

    protected class CompleteRepSource
    implements RepSource {
        protected CompleteRepSource() {
        }

        public String getStringRep(Object value) {
            return PartialForBean.this.getStringRepFromValue(value);
        }
    }

    protected static interface RepSource {
        public String getStringRep(Object var1);
    }
}

