/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.ajax.components;

import java.text.NumberFormat;
import net.sf.tacos.ajax.AjaxDirectServiceParameter;
import net.sf.tacos.ajax.AjaxWebRequest;
import net.sf.tacos.ajax.components.ProgressWorker;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IDirect;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.engine.IEngineService;

public abstract class ProgressBar
extends BaseComponent
implements IDirect {
    private static final Log log = LogFactory.getLog((Class)ProgressBar.class);

    public abstract ProgressWorker getWorker();

    public abstract void setWorker(ProgressWorker var1);

    public abstract int getTruncateLength();

    public abstract IEngineService getAjaxService();

    public abstract AjaxWebRequest getAjaxRequest();

    public abstract String getElement();

    public abstract String getOnCompleteObject();

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        String element = this.getElement();
        if (!cycle.isRewinding() && element != null) {
            writer.begin(element);
            this.renderInformalParameters(writer, cycle);
        }
        super.renderComponent(writer, cycle);
        if (!cycle.isRewinding() && element != null) {
            writer.end();
        }
        if (this.getAjaxRequest().isValidRequest() && this.getWorker() != null && this.getWorker().isComplete() && this.getOnCompleteObject() != null) {
            this.getAjaxRequest().getResponseBuilder().getScriptWriter().printRaw("<script type=\"text/javascript\">\n if (typeof " + this.getOnCompleteObject() + " != \"undefined\") {\n" + this.getOnCompleteObject() + ".progressFinished(\"" + this.getUpdateId() + "\");\n" + "}\n" + "</script>\n");
        }
    }

    public NumberFormat getNumberFormat() {
        return NumberFormat.getIntegerInstance();
    }

    public String truncate(String input) {
        return StringUtils.abbreviate((String)input, (int)this.getTruncateLength());
    }

    public void cancelTask(IRequestCycle cycle) {
        log.debug((Object)"cancelTask()");
        ProgressWorker worker = this.getWorker();
        if (worker == null || worker.isComplete()) {
            return;
        }
        worker.cancelTask();
    }

    public boolean isStateful() {
        return false;
    }

    public void trigger(IRequestCycle cycle) {
        log.debug((Object)("trigger worker exists?:" + (this.getWorker() != null)));
        if (this.getWorker() != null) {
            log.debug((Object)("trigger worker complete?:" + this.getWorker().isComplete()));
        }
    }

    public String getUpdateId() {
        String id = this.getId();
        if (this.getBinding("id") != null && this.getBinding("id").getObject() != null) {
            id = this.getBinding("id").getObject().toString();
        }
        return id;
    }

    public String getLinkString() {
        return this.getAjaxService().getLink(false, (Object)new AjaxDirectServiceParameter((IDirect)this, new Object[0], new String[]{this.getUpdateId()}, false, true)).getAbsoluteURL();
    }
}

