/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.ajax.components.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Stack;

abstract class TreeIterator
implements Iterator {
    private final Stack todo = new Stack();
    private int depth = 0;
    private int previousDepth = 0;
    private int markers = 0;
    private static final Object MARKER = new Object();

    public TreeIterator(Object rootElement) {
        this.todo.push(rootElement);
    }

    public TreeIterator(Collection rootElements) {
        this.push(rootElements);
    }

    public int getDepth() {
        return this.depth;
    }

    public int getPreviousDepth() {
        return this.previousDepth;
    }

    public boolean hasNext() {
        return !this.todo.isEmpty() && this.todo.size() != this.markers;
    }

    public Object next() {
        Object node;
        do {
            if ((node = this.todo.pop()) != MARKER) continue;
            --this.markers;
        } while (node == MARKER);
        this.previousDepth = this.depth;
        this.depth = this.markers++;
        Collection children = this.getChildren(node);
        if (!children.isEmpty()) {
            this.todo.push(MARKER);
            this.push(children);
        }
        return node;
    }

    private void push(Collection elements) {
        ArrayList rev = new ArrayList(elements);
        Collections.reverse(rev);
        this.todo.addAll(rev);
    }

    protected abstract Collection getChildren(Object var1);

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

