/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.ajax.components.tree;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import net.sf.tacos.ajax.components.tree.ITreeManager;
import net.sf.tacos.model.IKeyProvider;
import net.sf.tacos.model.ITreeContentProvider;

public class TreeManager
implements ITreeManager {
    private final Set state;
    private final ITreeContentProvider contentProvider;
    private final IKeyProvider keyProvider;

    public TreeManager(Set state, ITreeContentProvider contentProvider, IKeyProvider keyProvider) {
        if (state == null || contentProvider == null || keyProvider == null) {
            throw new IllegalArgumentException("Null parameter passed.");
        }
        this.state = state;
        this.contentProvider = contentProvider;
        this.keyProvider = keyProvider;
    }

    public boolean isExpanded(Object element) {
        return this.isExpandedKey(this.keyProvider.getKey(element));
    }

    public boolean isExpandedKey(Serializable key) {
        return this.state.contains(key);
    }

    public void setExpanded(Object element, boolean open) {
        this.setExpandedKey(this.keyProvider.getKey(element), open);
    }

    public void setExpandedKey(Serializable key, boolean open) {
        if (open) {
            this.state.add(key);
        } else {
            this.state.remove(key);
        }
    }

    public Set getState() {
        return this.state;
    }

    public void collapseAll() {
        this.state.clear();
    }

    public Object reveal(Object element) {
        Object parent = this.contentProvider.getParent(element);
        if (parent != null) {
            this.setExpanded(parent, true);
            return this.reveal(parent);
        }
        return element;
    }

    public void expandAll() {
        this.expand(this.contentProvider.getElements());
    }

    private void expand(Collection rootElements) {
        Iterator i = rootElements.iterator();
        while (i.hasNext()) {
            Object element = i.next();
            this.setExpanded(element, true);
            if (!this.contentProvider.hasChildren(element)) continue;
            this.expand(this.contentProvider.getChildren(element));
        }
    }
}

