/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.ajax.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import net.sf.tacos.ajax.AjaxDirectService;
import net.sf.tacos.ajax.AjaxDirectServiceParameter;
import net.sf.tacos.ajax.AjaxWebRequest;
import net.sf.tacos.ajax.ResponseBuilder;
import net.sf.tacos.ajax.ResponseDelegateFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IDirect;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRedirectException;
import org.apache.tapestry.RedirectException;
import org.apache.tapestry.StaleSessionException;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.engine.EngineMessages;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.error.ExceptionPresenter;
import org.apache.tapestry.markup.MarkupWriterSource;
import org.apache.tapestry.services.LinkFactory;
import org.apache.tapestry.services.RequestLocaleManager;
import org.apache.tapestry.services.ResponseRenderer;
import org.apache.tapestry.util.ContentType;
import org.apache.tapestry.web.WebRequest;
import org.apache.tapestry.web.WebResponse;
import org.apache.tapestry.web.WebSession;

public class AjaxDirectServiceImpl
implements AjaxDirectService {
    public static final String SERVICE_NAME = "ajaxdirect";
    public static final String UPDATE_COMPONENTS = "updateid";
    public static final String UPDATE_DIRECT = "updatedirect";
    public static final String PROCESS_SCRIPTS = "processScripts";
    public static final String VISIBLE_WIDGETS = "widgetids";
    private static final String STATEFUL_ON = "T";
    private static final Log log = LogFactory.getLog((Class)AjaxDirectServiceImpl.class);
    protected static final Random rand = new Random();
    private WebResponse webResponse;
    private WebRequest webRequest;
    private ResponseRenderer responseRenderer;
    private LinkFactory linkFactory;
    private WebRequest request;
    private AjaxWebRequest ajaxRequest;
    private ResponseDelegateFactory delegateFactory;
    private IRequestCycle requestCycle;
    private ExceptionPresenter exceptionPresenter;
    private ExceptionPresenter staleSessionExceptionPresenter;
    private IEngineService pageService;
    private RequestLocaleManager localeManager;

    public String getName() {
        return SERVICE_NAME;
    }

    public ILink getLink(boolean post, Object parameter) {
        Defense.isAssignable((Object)parameter, (Class)AjaxDirectServiceParameter.class, (String)"Parameter passed not instance of AjaxDirectServiceParameter.");
        boolean stateful = this.request.getSession(false) != null;
        AjaxDirectServiceParameter dsp = (AjaxDirectServiceParameter)((Object)parameter);
        IDirect component = dsp.getDirect();
        IPage renderPage = this.requestCycle.getPage();
        IPage componentPage = component.getPage();
        String[] componentIds = dsp.getUpdateIds();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("service", this.getName());
        parameters.put("page", renderPage.getPageName());
        parameters.put("component", component.getIdPath());
        parameters.put("container", componentPage == renderPage ? null : componentPage.getPageName());
        parameters.put("session", stateful ? STATEFUL_ON : null);
        parameters.put("sp", dsp.getServiceParameters());
        parameters.put(UPDATE_COMPONENTS, componentIds);
        parameters.put(UPDATE_DIRECT, Boolean.toString(dsp.isUpdateDirect()));
        if (dsp.isProcessScripts()) {
            parameters.put(PROCESS_SCRIPTS, Boolean.toString(dsp.isProcessScripts()));
        }
        parameters.put("rand", String.valueOf(rand.nextInt()));
        return this.linkFactory.constructLink((IEngineService)this, post, parameters, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(IRequestCycle cycle) throws IOException {
        IDirect direct;
        String componentId = cycle.getParameter("component");
        String componentPageName = cycle.getParameter("container");
        String activePageName = cycle.getParameter("page");
        boolean activeSession = cycle.getParameter("session") != null;
        Object[] ucomps = this.getCycleParameters(cycle, UPDATE_COMPONENTS);
        if (ucomps != null) {
            this.ajaxRequest.getUpdateComponents().addAll(Arrays.asList(ucomps));
        }
        this.ajaxRequest.setDirectUpdate(Boolean.valueOf(cycle.getParameter(UPDATE_DIRECT)));
        this.ajaxRequest.setType(this.request.getHeader("X-Requested-With"));
        this.ajaxRequest.setVersion(this.request.getHeader("X-Prototype-Version"));
        if (cycle.getParameter(PROCESS_SCRIPTS) != null) {
            this.ajaxRequest.setProcessScripts(Boolean.valueOf(cycle.getParameter(PROCESS_SCRIPTS)));
        }
        String[] widgetids = TapestryUtils.split((String)cycle.getParameter(VISIBLE_WIDGETS));
        this.ajaxRequest.setVisibleWidgets(Arrays.asList(widgetids));
        if (log.isDebugEnabled()) {
            Iterator compIt = this.ajaxRequest.getUpdateComponents().iterator();
            while (compIt.hasNext()) {
                log.debug((Object)("Refreshing component id:" + compIt.next()));
            }
        }
        IPage renderPage = cycle.getPage(activePageName);
        cycle.activate(renderPage);
        IPage componentPage = componentPageName == null ? renderPage : cycle.getPage(componentPageName);
        IComponent component = componentPage.getNestedComponent(componentId);
        try {
            direct = (IDirect)component;
        }
        catch (ClassCastException ex) {
            throw new ApplicationRuntimeException((Throwable)ex);
        }
        Object[] serviceParms = this.linkFactory.extractListenerParameters(cycle);
        cycle.setListenerParameters(serviceParms);
        log.debug((Object)("Got serviceParms of length " + serviceParms.length));
        ResponseBuilder responseBuilder = this.delegateFactory.getResponseBuilder(cycle, this.request);
        this.ajaxRequest.setResponseBuilder(responseBuilder);
        if (responseBuilder != null && this.ajaxRequest.isValidRequest()) {
            responseBuilder.setAjaxRequest(this.ajaxRequest);
            cycle.setAttribute("ajax-request", (Object)this.ajaxRequest);
        }
        if (responseBuilder == null || !this.ajaxRequest.isValidRequest()) {
            log.warn((Object)"Header with key X-Requested-With and expected value XMLHttpRequest did not exist, performing non-ajax http response.");
            this.triggerComponent(cycle, direct);
            this.responseRenderer.renderResponse(cycle);
            return;
        }
        ContentType ct = new ContentType(responseBuilder.getContentType() + ";charset=" + cycle.getInfrastructure().getOutputEncoding());
        PrintWriter output = this.webResponse.getPrintWriter(ct);
        MarkupWriterSource mw = cycle.getInfrastructure().getMarkupWriterSource();
        IMarkupWriter w = mw.newMarkupWriter(output, ct);
        responseBuilder.setWriter(w);
        responseBuilder.prepareForRender();
        boolean shouldCommit = false;
        try {
            try {
                WebSession session;
                if (activeSession && direct.isStateful() && ((session = this.request.getSession(false)) == null || session.isNew())) {
                    throw new StaleSessionException(EngineMessages.requestStateSession((IComponent)direct), direct.getPage());
                }
                this.triggerComponent(cycle, direct);
                if (responseBuilder != null && this.ajaxRequest.isValidRequest()) {
                    responseBuilder.setAjaxRequest(this.ajaxRequest);
                    cycle.setAttribute("ajax-request", (Object)this.ajaxRequest);
                }
            }
            catch (RedirectException ex) {
                shouldCommit = true;
                this.handleRedirect(responseBuilder, ex.getRedirectLocation());
            }
            catch (PageRedirectException ex) {
                shouldCommit = true;
                ILink link = this.getPageService().getLink(true, (Object)ex.getTargetPageName());
                this.handleRedirect(responseBuilder, link.getURL());
            }
            catch (StaleSessionException ex) {
                try {
                    log.error((Object)"StaleSession ", (Throwable)ex);
                }
                catch (Throwable x) {
                    // empty catch block
                }
                this.staleSessionExceptionPresenter.presentException(cycle, (Throwable)ex);
            }
            catch (Throwable et) {
                try {
                    log.error((Object)("Error invoking listener on component " + direct.getClass().getName()), et);
                }
                catch (Throwable x) {
                    x.printStackTrace();
                }
                this.exceptionPresenter.presentException(cycle, et);
            }
            this.localeManager.persistLocale();
            if (this.checkNewPageActivated(cycle, renderPage, responseBuilder)) {
                shouldCommit = true;
            }
            try {
                this.renderAjaxResponse(cycle, renderPage, componentPage, component, responseBuilder);
            }
            catch (Throwable et) {
                try {
                    log.error((Object)"Error rendering Ajax Response: ", et);
                }
                catch (Throwable x) {
                    // empty catch block
                }
                this.exceptionPresenter.presentException(cycle, et);
            }
        }
        finally {
            if (shouldCommit) {
                cycle.commitPageChanges();
            }
            responseBuilder.cleanupAfterRender();
        }
    }

    protected boolean checkNewPageActivated(IRequestCycle cycle, IPage activePage, ResponseBuilder responseBuilder) {
        if (cycle.getPage() != activePage) {
            ILink link = this.getPageService().getLink(true, (Object)cycle.getPage().getPageName());
            this.handleRedirect(responseBuilder, link.getURL());
            return true;
        }
        return false;
    }

    protected void handleRedirect(ResponseBuilder responseBuilder, String redirectURL) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Redirecting to: " + redirectURL));
        }
        IMarkupWriter mw = responseBuilder.getWriter();
        mw.begin("script");
        mw.attribute("type", "text/javascript");
        mw.printRaw("//<![CDATA[");
        mw.println();
        mw.printRaw("window.location.href = '" + redirectURL + "'");
        mw.println();
        mw.printRaw("//]]>");
        mw.println();
        mw.end();
    }

    protected void triggerComponent(IRequestCycle cycle, IDirect direct) {
        direct.trigger(cycle);
    }

    protected void renderAjaxResponse(IRequestCycle cycle, IPage renderPage, IPage componentPage, IComponent component, ResponseBuilder responseBuilder) {
        if (this.ajaxRequest.isDirectUpdate()) {
            responseBuilder.updateComponentsDirect(cycle, renderPage, componentPage, component);
        } else {
            responseBuilder.renderResponse(cycle, renderPage, componentPage, component);
        }
    }

    private Object[] getCycleParameters(IRequestCycle cycle, String param) {
        Object[] values = cycle.getParameters(param);
        if (values != null && values.length == 1 && values[0] instanceof String) {
            String value = (String)values[0];
            values = value.split("[\n\r]+");
        }
        return values;
    }

    public void setAjaxRequest(AjaxWebRequest ajaxRequest) {
        this.ajaxRequest = ajaxRequest;
    }

    public AjaxWebRequest getAjaxRequest() {
        return this.ajaxRequest;
    }

    public void setWebResponse(WebResponse webResponse) {
        this.webResponse = webResponse;
    }

    public void setResponseRenderer(ResponseRenderer responseRenderer) {
        this.responseRenderer = responseRenderer;
    }

    public void setLinkFactory(LinkFactory linkFactory) {
        this.linkFactory = linkFactory;
    }

    public void setRequest(WebRequest request) {
        this.request = request;
    }

    public void setDelegateFactory(ResponseDelegateFactory delegateFactory) {
        this.delegateFactory = delegateFactory;
    }

    public void setRequestCycle(IRequestCycle requestCycle) {
        this.requestCycle = requestCycle;
    }

    public void setExceptionPresenter(ExceptionPresenter exceptionPresenter) {
        this.exceptionPresenter = exceptionPresenter;
    }

    public void setStaleSessionExceptionPresenter(ExceptionPresenter staleSessionExceptionPresenter) {
        this.staleSessionExceptionPresenter = staleSessionExceptionPresenter;
    }

    public IEngineService getPageService() {
        return this.pageService;
    }

    public void setPageService(IEngineService pageService) {
        this.pageService = pageService;
    }

    public WebRequest getWebRequest() {
        return this.webRequest;
    }

    public void setWebRequest(WebRequest webRequest) {
        this.webRequest = webRequest;
    }

    public void setLocaleManager(RequestLocaleManager localeManager) {
        this.localeManager = localeManager;
    }
}

