/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.ajax.impl;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import net.sf.tacos.ajax.AjaxWebRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.service.MethodSignature;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.engine.IScriptSource;
import org.apache.tapestry.enhance.EnhanceUtils;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.enhance.EnhancementWorker;
import org.apache.tapestry.form.AbstractFormComponent;
import org.apache.tapestry.services.ExpressionEvaluator;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.IParameterSpecification;
import org.apache.tapestry.spec.ParameterSpecification;

public class FormComponentEventWorker
implements EnhancementWorker {
    private static final Log log = LogFactory.getLog((Class)FormComponentEventWorker.class);
    protected AjaxWebRequest ajaxRequest;
    protected ExpressionEvaluator expressionEvaluator;
    protected IScriptSource scriptSource;
    public static final String EVENT_PARAMETER = "eventListener";
    public static final String FORMATTER_PARAMETER = "formatter";
    protected static final String RENDER_METHOD = "renderFormComponent";
    protected static final Class[] RENDER_PARAMS = new Class[]{IMarkupWriter.class, IRequestCycle.class};

    public void performEnhancement(EnhancementOperation op, IComponentSpecification spec) {
        ParameterSpecification ps;
        if (!AbstractFormComponent.class.isAssignableFrom(op.getBaseClass())) {
            return;
        }
        if (spec.getParameter(EVENT_PARAMETER) == null) {
            ps = new ParameterSpecification();
            ps.setParameterName(EVENT_PARAMETER);
            ps.setPropertyName(EVENT_PARAMETER);
            ps.setLocation(spec.getLocation());
            spec.addParameter((IParameterSpecification)ps);
        }
        if (spec.getParameter(FORMATTER_PARAMETER) == null) {
            ps = new ParameterSpecification();
            ps.setParameterName(FORMATTER_PARAMETER);
            ps.setPropertyName(FORMATTER_PARAMETER);
            ps.setLocation(spec.getLocation());
            spec.addParameter((IParameterSpecification)ps);
        }
        Method renderMethod = null;
        try {
            renderMethod = op.getBaseClass().getDeclaredMethod(RENDER_METHOD, RENDER_PARAMS);
        }
        catch (NoSuchMethodException e) {
            return;
        }
        MethodSignature accessor = this.createRequestAccessor(op, spec);
        MethodSignature expr = this.createExpressionAccessor(op, spec);
        MethodSignature scriptSourceAccessor = this.createScriptSourceAccessor(op, spec);
        MethodSignature enhancedMethod = new MethodSignature(renderMethod);
        op.addMethod(renderMethod.getModifiers(), enhancedMethod, this.buildMethodCallBack(spec, enhancedMethod, accessor, expr, scriptSourceAccessor), spec.getLocation());
    }

    protected MethodSignature createRequestAccessor(EnhancementOperation op, IComponentSpecification spec) {
        MethodSignature returnval = null;
        String name = "enhAjaxReq";
        String fieldName = "_$" + name;
        op.claimProperty(fieldName);
        String injName = op.addInjectedField(fieldName, AjaxWebRequest.class, (Object)this.ajaxRequest);
        String methodName = EnhanceUtils.createAccessorMethodName((String)name);
        returnval = new MethodSignature(AjaxWebRequest.class, methodName, null, null);
        op.addMethod(1, returnval, "return " + injName + ";", spec.getLocation());
        return returnval;
    }

    protected MethodSignature createScriptSourceAccessor(EnhancementOperation op, IComponentSpecification spec) {
        MethodSignature returnval = null;
        String name = "enhScriptSource";
        String fieldName = "_$" + name;
        op.claimProperty(fieldName);
        String injName = op.addInjectedField(fieldName, IScriptSource.class, (Object)this.scriptSource);
        String methodName = EnhanceUtils.createAccessorMethodName((String)name);
        returnval = new MethodSignature(IScriptSource.class, methodName, null, null);
        op.addMethod(1, returnval, "return " + injName + ";", spec.getLocation());
        return returnval;
    }

    protected MethodSignature createExpressionAccessor(EnhancementOperation op, IComponentSpecification spec) {
        MethodSignature returnval = null;
        String name = "enhExpr";
        String fieldName = "_$" + name;
        op.claimProperty(fieldName);
        String injName = op.addInjectedField(fieldName, ExpressionEvaluator.class, (Object)this.expressionEvaluator);
        String methodName = EnhanceUtils.createAccessorMethodName((String)name);
        returnval = new MethodSignature(ExpressionEvaluator.class, methodName, null, null);
        op.addMethod(1, returnval, "return " + injName + ";", spec.getLocation());
        return returnval;
    }

    protected String buildMethodCallBack(IComponentSpecification spec, MethodSignature method, MethodSignature accessor, MethodSignature exprAccessor, MethodSignature scriptSourceAccessor) {
        StringBuffer buf = new StringBuffer("{\n");
        buf.append(MessageFormat.format("super.{0}($$);\n", method.getName()));
        buf.append(" if (isParameterBound(\"").append(EVENT_PARAMETER).append("\")) {\n").append("String eventListener = (String)getBinding(\"").append(EVENT_PARAMETER).append("\").getObject();\n");
        buf.append(" if (eventListener != null && eventListener.length() > 0) { ").append("org.apache.tapestry.PageRenderSupport prs = ").append("org.apache.tapestry.TapestryUtils.getPageRenderSupport($2, this);\n").append("net.sf.tacos.ajax.AjaxUtils.linkFieldObservers(").append("$2, ").append(exprAccessor.getName()).append("(), ").append(accessor.getName()).append("(), ").append(" this, prs, eventListener);\n").append(" } \n");
        buf.append("}");
        buf.append(" if (isParameterBound(\"").append(FORMATTER_PARAMETER).append("\")) {\n").append("net.sf.tacos.formatter.JsFormatter formatter = ").append("(net.sf.tacos.formatter.JsFormatter) getBinding(\"").append(FORMATTER_PARAMETER).append("\").getObject();\n");
        buf.append(" if (formatter != null) { ").append("net.sf.tacos.formatter.FormatterUtils.linkFormatter(").append("$2, ").append(scriptSourceAccessor.getName()).append("(), ").append(" this, formatter, null);\n").append(" } \n");
        buf.append("}");
        buf.append("}\n");
        return buf.toString();
    }

    public void setAjaxRequest(AjaxWebRequest ajaxRequest) {
        this.ajaxRequest = ajaxRequest;
    }

    public void setExpressionEvaluator(ExpressionEvaluator expressionEvaluator) {
        this.expressionEvaluator = expressionEvaluator;
    }

    public void setScriptSource(IScriptSource scriptSource) {
        this.scriptSource = scriptSource;
    }
}

