/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.ajax.impl;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import net.sf.tacos.ajax.AjaxWebRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.service.MethodSignature;
import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.enhance.EnhanceUtils;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.enhance.EnhancementWorker;
import org.apache.tapestry.html.Body;
import org.apache.tapestry.spec.IComponentSpecification;

public class InjectAjaxComponentRenderWorker
implements EnhancementWorker {
    private static final Log log = LogFactory.getLog((Class)InjectAjaxComponentRenderWorker.class);
    private AjaxWebRequest ajaxRequest;
    private static final String RENDER_METHOD = "renderComponent";
    private static final Class[] RENDER_PARAMS = new Class[]{IMarkupWriter.class, IRequestCycle.class};

    public void setAjaxRequest(AjaxWebRequest ajaxRequest) {
        this.ajaxRequest = ajaxRequest;
    }

    public void performEnhancement(EnhancementOperation op, IComponentSpecification spec) {
        if (!AbstractComponent.class.isAssignableFrom(op.getBaseClass())) {
            log.warn((Object)("Not assignable from AbstractComponent:" + spec.getComponentClassName() + " with base class:" + op.getBaseClass().getName()));
            return;
        }
        boolean bodyComponent = Body.class.isAssignableFrom(op.getBaseClass());
        Method renderMethod = null;
        try {
            renderMethod = op.getBaseClass().getDeclaredMethod(RENDER_METHOD, RENDER_PARAMS);
        }
        catch (NoSuchMethodException e) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating ajax render enhancements for class " + op.getBaseClass().getName()));
        }
        MethodSignature accessor = this.createAjaxRequestAccessor(op, spec);
        MethodSignature enhancedMethod = new MethodSignature(renderMethod);
        op.addMethod(renderMethod.getModifiers(), enhancedMethod, bodyComponent ? this.buildScriptMethodCallBack(spec, enhancedMethod, accessor) : this.buildMethodCallBack(spec, enhancedMethod, accessor), spec.getLocation());
    }

    protected MethodSignature createAjaxRequestAccessor(EnhancementOperation op, IComponentSpecification spec) {
        MethodSignature returnval = null;
        String name = "enhWebRequest";
        String fieldName = "_$" + name;
        op.claimProperty(fieldName);
        String injName = op.addInjectedField(fieldName, AjaxWebRequest.class, (Object)this.ajaxRequest);
        String methodName = EnhanceUtils.createAccessorMethodName((String)name);
        returnval = new MethodSignature(AjaxWebRequest.class, methodName, null, null);
        op.addMethod(1, returnval, "return " + injName + ";", spec.getLocation());
        return returnval;
    }

    protected String buildMethodCallBack(IComponentSpecification spec, MethodSignature method, MethodSignature accessor) {
        StringBuffer buf = new StringBuffer("{\n");
        buf.append(" net.sf.tacos.ajax.AjaxWebRequest ajaxRequest = ").append(accessor.getName()).append("(); \n");
        buf.append(" if (ajaxRequest != null && ajaxRequest.isValidRequest()").append(" && ajaxRequest.getResponseBuilder() != null) {\n");
        buf.append("  $1 = ajaxRequest.getResponseBuilder().getWriter(this, $2, $1); \n");
        buf.append(" }\n");
        buf.append(MessageFormat.format("super.{0}($$);\n", method.getName()));
        buf.append("}\n");
        return buf.toString();
    }

    protected String buildScriptMethodCallBack(IComponentSpecification spec, MethodSignature method, MethodSignature accessor) {
        StringBuffer buf = new StringBuffer("{\n");
        buf.append(" net.sf.tacos.ajax.AjaxWebRequest ajaxRequest = ").append(accessor.getName()).append("(); \n");
        buf.append(" if (ajaxRequest != null && ajaxRequest.isValidRequest() ").append("&& ajaxRequest.getResponseBuilder() != null) {\n");
        buf.append("  $1 = ajaxRequest.getResponseBuilder().getWriter(this, $2, $1); \n");
        buf.append(" }\n");
        buf.append(MessageFormat.format("super.{0}($$);\n", method.getName()));
        buf.append("\n if (ajaxRequest != null && ajaxRequest.isValidRequest()").append(" && ajaxRequest.isProcessScripts() && ").append("ajaxRequest.getResponseBuilder() != null) {\n");
        buf.append(" java.lang.reflect.Field pfield = $2.getClass().getClassLoader()").append(".loadClass(\"org.apache.tapestry.html.Body\").getDeclaredField(\"_pageRenderSupport\");");
        buf.append(" pfield.setAccessible(true);");
        buf.append(" org.apache.tapestry.util.PageRenderSupportImpl prs = ").append(" (org.apache.tapestry.util.PageRenderSupportImpl)pfield.get(this);");
        buf.append(" prs.writeBodyScript(").append("ajaxRequest.getResponseBuilder().getScriptWriter(), $2);\n");
        buf.append(" prs.writeInitializationScript(").append("ajaxRequest.getResponseBuilder().getScriptWriter());\n");
        buf.append(" }\n");
        buf.append("}\n");
        return buf.toString();
    }
}

