/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.form.validator;

import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.form.FormComponentContributorContext;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.form.ValidationMessages;
import org.apache.tapestry.form.validator.BaseValidator;
import org.apache.tapestry.multipart.UploadPart;
import org.apache.tapestry.util.RegexpMatcher;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidatorException;

public class FileTypeValidator
extends BaseValidator {
    private static String errorTemplate = "{0} only supports files of type {1}.";
    private String accept;

    public FileTypeValidator() {
    }

    public FileTypeValidator(String initializer) {
        super(initializer);
    }

    public void setFiletype(String acc) {
        this.accept = acc;
    }

    public void validate(IFormComponent field, ValidationMessages messages, Object object) throws ValidatorException {
        UploadPart part = (UploadPart)object;
        String name = part.getFileName();
        String ext = name.toLowerCase();
        int pos = ext.lastIndexOf(".");
        if (pos >= 0) {
            ext = ext.substring(pos + 1);
        }
        if (this.accept.indexOf(ext) >= 0) {
            return;
        }
        throw new ValidatorException(this.buildMessage(messages, field), ValidationConstraint.PATTERN_MISMATCH);
    }

    private String buildMessage(ValidationMessages messages, IFormComponent field) {
        String template = this.getMessage();
        if (template == null) {
            template = errorTemplate;
        }
        return messages.formatValidationMessage(template, "unsupported-file-type", new Object[]{field.getDisplayName(), this.accept});
    }

    public void renderContribution(IMarkupWriter writer, IRequestCycle cycle, FormComponentContributorContext context, IFormComponent field) {
        context.includeClasspathScript("/org/apache/tapestry/form/validator/RegExValidator.js");
        String toReg = this.accept.replace('-', '|');
        toReg = ".*\\.(" + toReg + ")$";
        String pattern = new RegexpMatcher().getEscapedPatternString(toReg);
        String message = this.buildMessage((ValidationMessages)context, field);
        StringBuffer buffer = new StringBuffer("function(event) { Tapestry.validate_regex(event, '");
        buffer.append(field.getClientId());
        buffer.append("', '");
        buffer.append(pattern);
        buffer.append("', ");
        buffer.append(TapestryUtils.enquote((String)message));
        buffer.append("); }");
        context.addSubmitHandler(buffer.toString());
    }
}

