/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.formatter;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import net.sf.tacos.ajax.AjaxUtils;
import net.sf.tacos.formatter.JsFormatter;
import net.sf.tacos.util.ScriptUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.Location;
import org.apache.hivemind.Resource;
import org.apache.hivemind.impl.DefaultClassResolver;
import org.apache.hivemind.util.ClasspathResource;
import org.apache.hivemind.util.PropertyUtils;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.IScriptProcessor;
import org.apache.tapestry.PageRenderSupport;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.engine.IScriptSource;

public class NumberJsFormatter
implements JsFormatter {
    private static final Log log = LogFactory.getLog((Class)NumberJsFormatter.class);
    public static final String FORMATTER_SCRIPT_RESOURCE = "/net/sf/tacos/formatter/NumberFormatter.script";
    private String signed = "[true,false]";
    private String separator;
    private String places;
    private String decimal;
    private String forceSeparator = "false";
    private String roundedPlaces;

    public NumberJsFormatter() {
    }

    public NumberJsFormatter(String initializer) {
        PropertyUtils.configureProperties((Object)this, (String)initializer);
    }

    public void renderContributions(IRequestCycle cycle, IScriptSource scriptSource, IComponent comp, String uniqueId) {
        log.debug((Object)("Rendering contributions for: " + comp.getId()));
        Locale locale = comp.getPage().getLocale();
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance(locale);
        DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
        String realSeparator = StringUtils.isEmpty((String)this.separator) ? String.valueOf(dfs.getGroupingSeparator()) : this.separator;
        String realDecimal = StringUtils.isEmpty((String)this.decimal) ? String.valueOf(dfs.getDecimalSeparator()) : this.decimal;
        String realRoundedPlaces = StringUtils.isEmpty((String)this.roundedPlaces) ? "Infinity" : this.roundedPlaces;
        String fieldId = ScriptUtils.getFieldId(comp, uniqueId);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("signed", StringUtils.trimToNull((String)this.signed));
        params.put("separator", StringUtils.trimToNull((String)realSeparator));
        params.put("places", StringUtils.trimToNull((String)this.places));
        params.put("decimal", StringUtils.trimToNull((String)realDecimal));
        params.put("forceSeparator", StringUtils.trimToNull((String)this.forceSeparator));
        params.put("roundedPlaces", StringUtils.trimToNull((String)realRoundedPlaces));
        params.put("componentId", StringUtils.trimToNull((String)fieldId));
        params.put("ajax", AjaxUtils.isAjaxCycle(cycle));
        PageRenderSupport prs = TapestryUtils.getPageRenderSupport((IRequestCycle)cycle, (IComponent)comp);
        Location location = comp.getSpecification().getLocation();
        ClasspathResource resource = new ClasspathResource((ClassResolver)new DefaultClassResolver(), FORMATTER_SCRIPT_RESOURCE);
        IScript script = scriptSource.getScript((Resource)resource);
        script.execute(cycle, (IScriptProcessor)prs, params);
    }

    public String getDecimal() {
        return this.decimal;
    }

    public void setDecimal(String decimal) {
        this.decimal = decimal;
    }

    public String getForceSeparator() {
        return this.forceSeparator;
    }

    public void setForceSeparator(String forceSeparator) {
        this.forceSeparator = forceSeparator;
    }

    public String getPlaces() {
        return this.places;
    }

    public void setPlaces(String places) {
        this.places = places;
    }

    public String getRoundedPlaces() {
        return this.roundedPlaces;
    }

    public void setRoundedPlaces(String roundedPlaces) {
        this.roundedPlaces = roundedPlaces;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getSigned() {
        return this.signed;
    }

    public void setSigned(String signed) {
        this.signed = signed;
    }

    public String toString() {
        ToStringBuilder tb = new ToStringBuilder((Object)this);
        tb.append("signed", (Object)this.signed);
        tb.append("separator", (Object)this.separator);
        tb.append("places", (Object)this.places);
        tb.append("decimal", (Object)this.decimal);
        tb.append("forceSeparator", (Object)this.forceSeparator);
        tb.append("roundedPlaces", (Object)this.roundedPlaces);
        return tb.toString();
    }
}

