/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tacos.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.form.IFormComponent;

public final class ScriptUtils {
    private static final Log log = LogFactory.getLog((Class)ScriptUtils.class);
    public static final String BEGIN_COMMENT = "\n<script>\n//<![CDATA[\n";
    public static final String END_COMMENT = "\n//]]>\n</script>\n";
    public static final Pattern SCRIPT_PATTERN = Pattern.compile("(?:<script.*?>)(.*?)(?:<\\/script>)", 44);
    public static final Pattern SCRIPT_INCLUDE_PATTERN = Pattern.compile("(?:<script.*?src=\")(.*)(?:\".*?></script>)");

    public static synchronized String ensureValidScriptTags(String input) {
        if (input == null) {
            return null;
        }
        Matcher matcher = SCRIPT_PATTERN.matcher(input);
        StringBuffer buffer = new StringBuffer(input.length());
        boolean matched = false;
        int end = 0;
        while (matcher.find()) {
            matched = true;
            String str = matcher.group(1);
            int pos = matcher.start() - end;
            end = matcher.end();
            if (str == null || str.trim().equals("")) {
                matcher.appendReplacement(buffer, "");
                continue;
            }
            StringBuffer thisTurn = new StringBuffer();
            matcher.appendReplacement(thisTurn, "\n<script>\n//<![CDATA[\n$1\n//]]>\n</script>\n");
            String curr = thisTurn.toString();
            String prefix = curr.substring(0, pos);
            String suffix = curr.substring(pos);
            suffix = StringUtils.replace((String)suffix, (String)"<!--", (String)"");
            suffix = StringUtils.replace((String)suffix, (String)"// -->", (String)"");
            buffer.append(prefix).append(suffix);
        }
        if (!matched) {
            buffer.append(input);
        } else {
            matcher.appendTail(buffer);
        }
        return buffer.toString();
    }

    public static synchronized void parseJSIncludes(String input, StringBuffer appender) {
        if (input == null) {
            return;
        }
        Matcher matcher = SCRIPT_INCLUDE_PATTERN.matcher(input);
        while (matcher.find()) {
            String src = StringEscapeUtils.unescapeHtml((String)matcher.group(1));
            appender.append(BEGIN_COMMENT).append("tacos.loadScriptFromUrl(\"").append(src).append("\");").append(END_COMMENT);
        }
    }

    public static String toJsStringArray(String[] a, int offset, int length) {
        StringBuffer sb = new StringBuffer(15 * length);
        for (int i = offset; i < length; ++i) {
            ScriptUtils.appendAsJsString(sb, a[i]);
            if (i >= length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String toJsStringArray(Iterator values) {
        StringBuffer sb = new StringBuffer();
        while (values.hasNext()) {
            ScriptUtils.appendAsJsString(sb, (String)values.next());
            if (!values.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String escapeJavaScriptHash(String jshash) {
        String result = jshash;
        try {
            int length = jshash.length();
            Stack<EscapeJSHash> newHashs = new Stack<EscapeJSHash>();
            Stack<String> keys = new Stack<String>();
            Stack values = new Stack();
            Stack quotes = new Stack();
            String token = "";
            for (int i = 0; i < length; ++i) {
                char ch = jshash.charAt(i);
                ScriptUtils.processQuoteStack(ch, quotes, '\"');
                ScriptUtils.processQuoteStack(ch, quotes, '\'');
                if (quotes.empty()) {
                    if (ch == '{') {
                        newHashs.push(new EscapeJSHash());
                    }
                    if (ch == ':') {
                        keys.push(token.trim());
                    }
                    if (ch == ',' || ch == '}') {
                        Map m = (Map)newHashs.peek();
                        if (token.trim().length() == 0) {
                            m.put(keys.pop(), values.pop());
                        } else {
                            m.put(keys.pop(), token.trim());
                        }
                    }
                    if (ch == '}') {
                        values.push(newHashs.pop());
                    }
                    if (ch == '{' || ch == '}' || ch == ',' || ch == ':') {
                        token = "";
                        continue;
                    }
                }
                token = token + ch;
            }
            if (!keys.empty()) {
                throw new IllegalStateException("All keys should be pop out!");
            }
            result = values.pop().toString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal JavaScript object : " + jshash);
        }
        return result;
    }

    public static Map createParamsMap(String initializer, String delim) {
        String[] strParams = StringUtils.split((String)initializer, (String)delim);
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < strParams.length; ++i) {
            String strParam = strParams[i];
            String name = StringUtils.trimToNull((String)strParam.substring(0, strParam.indexOf("=")));
            String value = StringUtils.trimToEmpty((String)strParam.substring(strParam.indexOf("=") + 1, strParam.length()));
            if (name == null) {
                throw new ApplicationRuntimeException("Parameter was found to be null or empty in string: \"" + initializer + "\"");
            }
            params.put(name, value);
        }
        return params;
    }

    private static void appendAsJsString(StringBuffer sb, String value) {
        sb.append('\'').append(StringEscapeUtils.escapeJavaScript((String)value)).append('\'');
    }

    private static void processQuoteStack(char ch, Stack quotes, char quote) {
        if (ch == quote) {
            String strQuote = String.valueOf(quote);
            if (!quotes.empty() && quotes.contains(strQuote)) {
                while (!strQuote.equals(quotes.peek())) {
                    quotes.pop();
                }
                quotes.pop();
            } else {
                quotes.push(strQuote);
            }
        }
    }

    private static String unifyJavaScriptString(String value) {
        if (value == null) {
            return "";
        }
        String result = value.trim();
        if (result.startsWith("\"") && result.endsWith("\"") || result.startsWith("'") && result.endsWith("'")) {
            result = result.substring(1, result.length() - 1);
        }
        StringBuffer sb = new StringBuffer();
        ScriptUtils.appendAsJsString(sb, result);
        return sb.toString();
    }

    public static String getFieldId(IComponent comp, String uniqueId) {
        String fieldId = uniqueId;
        if (fieldId == null) {
            fieldId = comp instanceof IFormComponent ? ((IFormComponent)comp).getClientId() : comp.getId();
        }
        return fieldId;
    }

    public static IComponent getContainer(IComponent comp) {
        IComponent container = comp.getContainer();
        if (container == null) {
            container = comp.getPage();
        }
        return container;
    }

    private static class EscapeJSHash
    extends LinkedHashMap {
        private static final long serialVersionUID = -4407940748388783414L;

        private EscapeJSHash() {
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("{");
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                Object key = e.getKey();
                Object value = e.getValue();
                if (value instanceof String) {
                    value = ScriptUtils.unifyJavaScriptString(value.toString());
                }
                buf.append(ScriptUtils.unifyJavaScriptString(key.toString())).append(": ").append(value);
                if (!i.hasNext()) continue;
                buf.append(", ");
            }
            buf.append("}");
            return buf.toString();
        }
    }
}

