/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.tools.model;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.descriptor.DuplicateParameterException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.tools.model.Component;
import org.apache.maven.plugin.tools.model.LifecycleExecution;
import org.apache.maven.plugin.tools.model.Mojo;
import org.apache.maven.plugin.tools.model.Parameter;
import org.apache.maven.plugin.tools.model.PluginMetadata;
import org.apache.maven.plugin.tools.model.PluginMetadataParseException;
import org.apache.maven.plugin.tools.model.io.xpp3.PluginMetadataXpp3Reader;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class PluginMetadataParser {
    public static final String IMPL_BASE_PLACEHOLDER = "<REPLACE-WITH-MOJO-PATH>";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set parseMojoDescriptors(File metadataFile) throws PluginMetadataParseException {
        HashSet<MojoDescriptor> descriptors = new HashSet<MojoDescriptor>();
        FileReader reader = null;
        try {
            reader = new FileReader(metadataFile);
            PluginMetadataXpp3Reader metadataReader = new PluginMetadataXpp3Reader();
            PluginMetadata pluginMetadata = metadataReader.read(reader);
            List mojos = pluginMetadata.getMojos();
            if (mojos != null && !mojos.isEmpty()) {
                Iterator it = mojos.iterator();
                while (it.hasNext()) {
                    Mojo mojo = (Mojo)it.next();
                    MojoDescriptor descriptor = this.asDescriptor(metadataFile, mojo);
                    descriptors.add(descriptor);
                }
            }
        }
        catch (IOException e) {
            try {
                throw new PluginMetadataParseException(metadataFile, "Cannot parse plugin metadata from file.", e);
                catch (XmlPullParserException e2) {
                    throw new PluginMetadataParseException(metadataFile, "Cannot parse plugin metadata from file.", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        return descriptors;
    }

    private MojoDescriptor asDescriptor(File metadataFile, Mojo mojo) throws PluginMetadataParseException {
        List components;
        List parameters;
        MojoDescriptor descriptor = new MojoDescriptor();
        descriptor.setImplementation("<REPLACE-WITH-MOJO-PATH>:" + mojo.getCall());
        descriptor.setGoal(mojo.getGoal());
        descriptor.setPhase(mojo.getPhase());
        descriptor.setDependencyResolutionRequired(mojo.getRequiresDependencyResolution());
        descriptor.setAggregator(mojo.isAggregator());
        descriptor.setInheritedByDefault(mojo.isInheritByDefault());
        descriptor.setDirectInvocationOnly(mojo.isRequiresDirectInvocation());
        descriptor.setOnlineRequired(mojo.isRequiresOnline());
        descriptor.setProjectRequired(mojo.isRequiresProject());
        descriptor.setRequiresReports(mojo.isRequiresReports());
        descriptor.setDescription(mojo.getDescription());
        descriptor.setDeprecated(mojo.getDeprecation());
        LifecycleExecution le = mojo.getExecution();
        if (le != null) {
            descriptor.setExecuteLifecycle(le.getLifecycle());
            descriptor.setExecutePhase(le.getPhase());
        }
        if ((parameters = mojo.getParameters()) != null && !parameters.isEmpty()) {
            Iterator it = parameters.iterator();
            while (it.hasNext()) {
                Parameter param = (Parameter)it.next();
                org.apache.maven.plugin.descriptor.Parameter dParam = new org.apache.maven.plugin.descriptor.Parameter();
                dParam.setAlias(param.getAlias());
                dParam.setDeprecated(param.getDeprecation());
                dParam.setDescription(param.getDescription());
                dParam.setEditable(!param.isReadonly());
                dParam.setExpression(param.getExpression());
                dParam.setDefaultValue(param.getDefaultValue());
                String property = param.getProperty();
                if (StringUtils.isNotEmpty((String)property)) {
                    dParam.setName(property);
                } else {
                    dParam.setName(param.getName());
                }
                if (StringUtils.isEmpty((String)dParam.getName())) {
                    throw new PluginMetadataParseException(metadataFile, "Mojo: '" + mojo.getGoal() + "' has a parameter without either property or name attributes. Please specify one.");
                }
                dParam.setRequired(param.isRequired());
                dParam.setType(param.getType());
                try {
                    descriptor.addParameter(dParam);
                }
                catch (DuplicateParameterException e) {
                    throw new PluginMetadataParseException(metadataFile, "Duplicate parameters detected for mojo: " + mojo.getGoal(), e);
                }
            }
        }
        if ((components = mojo.getComponents()) != null && !components.isEmpty()) {
            Iterator it = components.iterator();
            while (it.hasNext()) {
                Component component = (Component)it.next();
                ComponentRequirement cr = new ComponentRequirement();
                cr.setRole(component.getRole());
                cr.setRoleHint(component.getHint());
                descriptor.addRequirement(cr);
            }
        }
        return descriptor;
    }
}

