/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.tools.model.io.xpp3;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.plugin.tools.model.Component;
import org.apache.maven.plugin.tools.model.LifecycleExecution;
import org.apache.maven.plugin.tools.model.Mojo;
import org.apache.maven.plugin.tools.model.Parameter;
import org.apache.maven.plugin.tools.model.PluginMetadata;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class PluginMetadataXpp3Writer {
    private String NAMESPACE;

    public void write(Writer writer, PluginMetadata pluginMetadata) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(pluginMetadata.getModelEncoding(), null);
        this.writePluginMetadata(pluginMetadata, "pluginMetadata", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeComponent(Component component, String tagName, XmlSerializer serializer) throws IOException {
        if (component != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (component.getRole() != null) {
                serializer.startTag(this.NAMESPACE, "role").text(component.getRole()).endTag(this.NAMESPACE, "role");
            }
            if (component.getHint() != null) {
                serializer.startTag(this.NAMESPACE, "hint").text(component.getHint()).endTag(this.NAMESPACE, "hint");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeLifecycleExecution(LifecycleExecution lifecycleExecution, String tagName, XmlSerializer serializer) throws IOException {
        if (lifecycleExecution != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (lifecycleExecution.getLifecycle() != null) {
                serializer.startTag(this.NAMESPACE, "lifecycle").text(lifecycleExecution.getLifecycle()).endTag(this.NAMESPACE, "lifecycle");
            }
            if (lifecycleExecution.getPhase() != null) {
                serializer.startTag(this.NAMESPACE, "phase").text(lifecycleExecution.getPhase()).endTag(this.NAMESPACE, "phase");
            }
            if (lifecycleExecution.getGoal() != null) {
                serializer.startTag(this.NAMESPACE, "goal").text(lifecycleExecution.getGoal()).endTag(this.NAMESPACE, "goal");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeMojo(Mojo mojo, String tagName, XmlSerializer serializer) throws IOException {
        if (mojo != null) {
            Serializable o;
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (mojo.getGoal() != null) {
                serializer.startTag(this.NAMESPACE, "goal").text(mojo.getGoal()).endTag(this.NAMESPACE, "goal");
            }
            if (mojo.getPhase() != null) {
                serializer.startTag(this.NAMESPACE, "phase").text(mojo.getPhase()).endTag(this.NAMESPACE, "phase");
            }
            if (mojo.isAggregator()) {
                serializer.startTag(this.NAMESPACE, "aggregator").text(String.valueOf(mojo.isAggregator())).endTag(this.NAMESPACE, "aggregator");
            }
            if (mojo.getRequiresDependencyResolution() != null) {
                serializer.startTag(this.NAMESPACE, "requiresDependencyResolution").text(mojo.getRequiresDependencyResolution()).endTag(this.NAMESPACE, "requiresDependencyResolution");
            }
            if (mojo.isRequiresProject()) {
                serializer.startTag(this.NAMESPACE, "requiresProject").text(String.valueOf(mojo.isRequiresProject())).endTag(this.NAMESPACE, "requiresProject");
            }
            if (mojo.isRequiresReports()) {
                serializer.startTag(this.NAMESPACE, "requiresReports").text(String.valueOf(mojo.isRequiresReports())).endTag(this.NAMESPACE, "requiresReports");
            }
            if (mojo.isRequiresOnline()) {
                serializer.startTag(this.NAMESPACE, "requiresOnline").text(String.valueOf(mojo.isRequiresOnline())).endTag(this.NAMESPACE, "requiresOnline");
            }
            if (mojo.isInheritByDefault()) {
                serializer.startTag(this.NAMESPACE, "inheritByDefault").text(String.valueOf(mojo.isInheritByDefault())).endTag(this.NAMESPACE, "inheritByDefault");
            }
            if (mojo.isRequiresDirectInvocation()) {
                serializer.startTag(this.NAMESPACE, "requiresDirectInvocation").text(String.valueOf(mojo.isRequiresDirectInvocation())).endTag(this.NAMESPACE, "requiresDirectInvocation");
            }
            if (mojo.getExecution() != null) {
                this.writeLifecycleExecution(mojo.getExecution(), "execution", serializer);
            }
            if (mojo.getComponents() != null && mojo.getComponents().size() > 0) {
                serializer.startTag(this.NAMESPACE, "components");
                iter = mojo.getComponents().iterator();
                while (iter.hasNext()) {
                    o = (Component)iter.next();
                    this.writeComponent((Component)o, "component", serializer);
                }
                serializer.endTag(this.NAMESPACE, "components");
            }
            if (mojo.getParameters() != null && mojo.getParameters().size() > 0) {
                serializer.startTag(this.NAMESPACE, "parameters");
                iter = mojo.getParameters().iterator();
                while (iter.hasNext()) {
                    o = (Parameter)iter.next();
                    this.writeParameter((Parameter)o, "parameter", serializer);
                }
                serializer.endTag(this.NAMESPACE, "parameters");
            }
            if (mojo.getDescription() != null) {
                serializer.startTag(this.NAMESPACE, "description").text(mojo.getDescription()).endTag(this.NAMESPACE, "description");
            }
            if (mojo.getDeprecation() != null) {
                serializer.startTag(this.NAMESPACE, "deprecated").text(mojo.getDeprecation()).endTag(this.NAMESPACE, "deprecated");
            }
            if (mojo.getCall() != null) {
                serializer.startTag(this.NAMESPACE, "call").text(mojo.getCall()).endTag(this.NAMESPACE, "call");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeParameter(Parameter parameter, String tagName, XmlSerializer serializer) throws IOException {
        if (parameter != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (parameter.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(parameter.getName()).endTag(this.NAMESPACE, "name");
            }
            if (parameter.getAlias() != null) {
                serializer.startTag(this.NAMESPACE, "alias").text(parameter.getAlias()).endTag(this.NAMESPACE, "alias");
            }
            if (parameter.getProperty() != null) {
                serializer.startTag(this.NAMESPACE, "property").text(parameter.getProperty()).endTag(this.NAMESPACE, "property");
            }
            if (parameter.isRequired()) {
                serializer.startTag(this.NAMESPACE, "required").text(String.valueOf(parameter.isRequired())).endTag(this.NAMESPACE, "required");
            }
            if (parameter.isReadonly()) {
                serializer.startTag(this.NAMESPACE, "readonly").text(String.valueOf(parameter.isReadonly())).endTag(this.NAMESPACE, "readonly");
            }
            if (parameter.getExpression() != null) {
                serializer.startTag(this.NAMESPACE, "expression").text(parameter.getExpression()).endTag(this.NAMESPACE, "expression");
            }
            if (parameter.getDefaultValue() != null) {
                serializer.startTag(this.NAMESPACE, "defaultValue").text(parameter.getDefaultValue()).endTag(this.NAMESPACE, "defaultValue");
            }
            if (parameter.getType() != null) {
                serializer.startTag(this.NAMESPACE, "type").text(parameter.getType()).endTag(this.NAMESPACE, "type");
            }
            if (parameter.getDescription() != null) {
                serializer.startTag(this.NAMESPACE, "description").text(parameter.getDescription()).endTag(this.NAMESPACE, "description");
            }
            if (parameter.getDeprecation() != null) {
                serializer.startTag(this.NAMESPACE, "deprecated").text(parameter.getDeprecation()).endTag(this.NAMESPACE, "deprecated");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writePluginMetadata(PluginMetadata pluginMetadata, String tagName, XmlSerializer serializer) throws IOException {
        if (pluginMetadata != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (pluginMetadata.getMojos() != null && pluginMetadata.getMojos().size() > 0) {
                serializer.startTag(this.NAMESPACE, "mojos");
                Iterator iter = pluginMetadata.getMojos().iterator();
                while (iter.hasNext()) {
                    Mojo o = (Mojo)iter.next();
                    this.writeMojo(o, "mojo", serializer);
                }
                serializer.endTag(this.NAMESPACE, "mojos");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }
}

