/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.catalog.event.impl.CatalogAddEventImpl;
import org.geoserver.catalog.event.impl.CatalogRemoveEventImpl;
import org.geoserver.gwc.layer.CatalogConfiguration;
import org.geoserver.gwc.layer.CatalogLayerEventListener;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class CatalogLayerEventListenerTest
extends TestCase {
    private static final String NAMESPACE_PREFIX = "mock";
    private static final String RESOURCE_NAME = "Layer";
    private static final String PREFIXED_RESOURCE_NAME = "mock:Layer";
    private static final String LAYER_GROUP_NAME = "LayerGroupName";
    private CatalogConfiguration mockConfiguration;
    private LayerInfo mockLayerInfo;
    private ResourceInfo mockResourceInfo;
    private NamespaceInfo mockNamespaceInfo;
    private LayerGroupInfo mockLayerGroupInfo;
    private CatalogLayerEventListener listener;

    protected void setUp() throws Exception {
        this.mockConfiguration = (CatalogConfiguration)Mockito.mock(CatalogConfiguration.class);
        this.mockLayerInfo = (LayerInfo)Mockito.mock(LayerInfo.class);
        this.mockLayerGroupInfo = (LayerGroupInfo)Mockito.mock(LayerGroupInfo.class);
        this.mockResourceInfo = (ResourceInfo)Mockito.mock(FeatureTypeInfo.class);
        this.mockNamespaceInfo = (NamespaceInfo)Mockito.mock(NamespaceInfo.class);
        Mockito.when((Object)this.mockLayerGroupInfo.getName()).thenReturn((Object)LAYER_GROUP_NAME);
        Mockito.when((Object)this.mockResourceInfo.getPrefixedName()).thenReturn((Object)PREFIXED_RESOURCE_NAME);
        Mockito.when((Object)this.mockResourceInfo.getName()).thenReturn((Object)RESOURCE_NAME);
        Mockito.when((Object)this.mockResourceInfo.getNamespace()).thenReturn((Object)this.mockNamespaceInfo);
        Mockito.when((Object)this.mockNamespaceInfo.getPrefix()).thenReturn((Object)NAMESPACE_PREFIX);
        Mockito.when((Object)this.mockLayerInfo.getResource()).thenReturn((Object)this.mockResourceInfo);
        this.listener = new CatalogLayerEventListener(this.mockConfiguration);
    }

    public void testLayerInfoAdded() throws Exception {
        CatalogAddEventImpl event = new CatalogAddEventImpl();
        event.setSource((CatalogInfo)this.mockLayerInfo);
        this.listener.handleAddEvent((CatalogAddEvent)event);
        ((CatalogConfiguration)Mockito.verify((Object)this.mockConfiguration)).createLayer((LayerInfo)Mockito.same((Object)this.mockLayerInfo));
    }

    public void testLayerGroupInfoAdded() throws Exception {
        CatalogAddEventImpl event = new CatalogAddEventImpl();
        event.setSource((CatalogInfo)this.mockLayerGroupInfo);
        this.listener.handleAddEvent((CatalogAddEvent)event);
        ((CatalogConfiguration)Mockito.verify((Object)this.mockConfiguration)).createLayer((LayerGroupInfo)Mockito.same((Object)this.mockLayerGroupInfo));
    }

    public void testLayerInfoRemoved() throws Exception {
        CatalogRemoveEventImpl event = new CatalogRemoveEventImpl();
        event.setSource((CatalogInfo)this.mockLayerInfo);
        this.listener.handleRemoveEvent((CatalogRemoveEvent)event);
        ((CatalogConfiguration)Mockito.verify((Object)this.mockConfiguration)).removeLayer((String)Matchers.eq((Object)this.mockResourceInfo.getPrefixedName()));
    }

    public void testLayerGroupInfoRemoved() throws Exception {
        CatalogRemoveEventImpl event = new CatalogRemoveEventImpl();
        event.setSource((CatalogInfo)this.mockLayerGroupInfo);
        this.listener.handleRemoveEvent((CatalogRemoveEvent)event);
        ((CatalogConfiguration)Mockito.verify((Object)this.mockConfiguration)).removeLayer((String)Matchers.eq((Object)this.mockLayerGroupInfo.getName()));
    }

    public void testResourceInfoRenamed() throws Exception {
        String renamedResouceName = "Layer_Renamed";
        String renamedPrefixedResouceName = "mock:Layer_Renamed";
        Mockito.when((Object)this.mockResourceInfo.getName()).thenReturn((Object)"Layer_Renamed");
        Mockito.when((Object)this.mockResourceInfo.getPrefixedName()).thenReturn((Object)"mock:Layer_Renamed");
        CatalogModifyEvent modifyEvent = (CatalogModifyEvent)Mockito.mock(CatalogModifyEvent.class);
        Mockito.when((Object)modifyEvent.getSource()).thenReturn((Object)this.mockResourceInfo);
        Mockito.when((Object)modifyEvent.getPropertyNames()).thenReturn(Arrays.asList("name"));
        Mockito.when((Object)modifyEvent.getOldValues()).thenReturn(Arrays.asList(RESOURCE_NAME));
        Mockito.when((Object)modifyEvent.getNewValues()).thenReturn(Arrays.asList("Layer_Renamed"));
        this.listener.handleModifyEvent(modifyEvent);
        CatalogPostModifyEvent postModifyEvent = (CatalogPostModifyEvent)Mockito.mock(CatalogPostModifyEvent.class);
        Mockito.when((Object)postModifyEvent.getSource()).thenReturn((Object)this.mockResourceInfo);
        this.listener.handlePostModifyEvent(postModifyEvent);
        ((CatalogConfiguration)Mockito.verify((Object)this.mockConfiguration)).renameTileLayer((String)Matchers.eq((Object)PREFIXED_RESOURCE_NAME), (String)Matchers.eq((Object)"mock:Layer_Renamed"));
    }

    public void testLayerGroupInfoRenamed() throws Exception {
        String renamedGroupName = "LayerGroupName_Renamed";
        Mockito.when((Object)this.mockLayerGroupInfo.getName()).thenReturn((Object)"LayerGroupName_Renamed");
        CatalogModifyEvent modifyEvent = (CatalogModifyEvent)Mockito.mock(CatalogModifyEvent.class);
        Mockito.when((Object)modifyEvent.getSource()).thenReturn((Object)this.mockLayerGroupInfo);
        Mockito.when((Object)modifyEvent.getPropertyNames()).thenReturn(Arrays.asList("name"));
        Mockito.when((Object)modifyEvent.getOldValues()).thenReturn(Arrays.asList(LAYER_GROUP_NAME));
        Mockito.when((Object)modifyEvent.getNewValues()).thenReturn(Arrays.asList("LayerGroupName_Renamed"));
        this.listener.handleModifyEvent(modifyEvent);
        CatalogPostModifyEvent postModifyEvent = (CatalogPostModifyEvent)Mockito.mock(CatalogPostModifyEvent.class);
        Mockito.when((Object)postModifyEvent.getSource()).thenReturn((Object)this.mockLayerGroupInfo);
        this.listener.handlePostModifyEvent(postModifyEvent);
        ((CatalogConfiguration)Mockito.verify((Object)this.mockConfiguration)).renameTileLayer((String)Matchers.eq((Object)LAYER_GROUP_NAME), (String)Matchers.eq((Object)"LayerGroupName_Renamed"));
    }

    public void testResourceInfoNamespaceChanged() throws Exception {
        NamespaceInfo newNamespace = (NamespaceInfo)Mockito.mock(NamespaceInfo.class);
        Mockito.when((Object)newNamespace.getPrefix()).thenReturn((Object)"newMock");
        String newPrefixedName = String.valueOf(newNamespace.getPrefix()) + ":" + this.mockResourceInfo.getName();
        Mockito.when((Object)this.mockResourceInfo.getNamespace()).thenReturn((Object)newNamespace);
        Mockito.when((Object)this.mockResourceInfo.getPrefixedName()).thenReturn((Object)newPrefixedName);
        CatalogModifyEvent modifyEvent = (CatalogModifyEvent)Mockito.mock(CatalogModifyEvent.class);
        Mockito.when((Object)modifyEvent.getSource()).thenReturn((Object)this.mockResourceInfo);
        Mockito.when((Object)modifyEvent.getPropertyNames()).thenReturn(Arrays.asList("namespace"));
        Mockito.when((Object)modifyEvent.getOldValues()).thenReturn(Arrays.asList(this.mockNamespaceInfo));
        Mockito.when((Object)modifyEvent.getNewValues()).thenReturn(Arrays.asList(newNamespace));
        this.listener.handleModifyEvent(modifyEvent);
        CatalogPostModifyEvent postModifyEvent = (CatalogPostModifyEvent)Mockito.mock(CatalogPostModifyEvent.class);
        Mockito.when((Object)postModifyEvent.getSource()).thenReturn((Object)this.mockResourceInfo);
        this.listener.handlePostModifyEvent(postModifyEvent);
        ((CatalogConfiguration)Mockito.verify((Object)this.mockConfiguration)).renameTileLayer((String)Matchers.eq((Object)PREFIXED_RESOURCE_NAME), (String)Matchers.eq((Object)newPrefixedName));
    }

    public void testLayerGroupInfoLayersChanged() throws Exception {
        CatalogModifyEvent modifyEvent = (CatalogModifyEvent)Mockito.mock(CatalogModifyEvent.class);
        Mockito.when((Object)modifyEvent.getSource()).thenReturn((Object)this.mockLayerGroupInfo);
        Mockito.when((Object)modifyEvent.getPropertyNames()).thenReturn(Arrays.asList("layers"));
        List oldLayers = Collections.emptyList();
        List<LayerInfo> newLayers = Collections.singletonList(this.mockLayerInfo);
        Mockito.when((Object)modifyEvent.getOldValues()).thenReturn(Collections.singletonList(oldLayers));
        Mockito.when((Object)modifyEvent.getNewValues()).thenReturn(Collections.singletonList(newLayers));
        this.listener.handleModifyEvent(modifyEvent);
        CatalogPostModifyEvent postModifyEvent = (CatalogPostModifyEvent)Mockito.mock(CatalogPostModifyEvent.class);
        Mockito.when((Object)postModifyEvent.getSource()).thenReturn((Object)this.mockLayerGroupInfo);
        this.listener.handlePostModifyEvent(postModifyEvent);
        ((CatalogConfiguration)Mockito.verify((Object)this.mockConfiguration)).truncate((String)Matchers.eq((Object)LAYER_GROUP_NAME));
    }

    public void testLayerGroupInfoStylesChanged() throws Exception {
        CatalogModifyEvent modifyEvent = (CatalogModifyEvent)Mockito.mock(CatalogModifyEvent.class);
        Mockito.when((Object)modifyEvent.getSource()).thenReturn((Object)this.mockLayerGroupInfo);
        Mockito.when((Object)modifyEvent.getPropertyNames()).thenReturn(Arrays.asList("styles"));
        List oldStyles = Collections.emptyList();
        StyleInfo newStyle = (StyleInfo)Mockito.mock(StyleInfo.class);
        List<StyleInfo> newStyles = Collections.singletonList(newStyle);
        Mockito.when((Object)modifyEvent.getOldValues()).thenReturn(Collections.singletonList(oldStyles));
        Mockito.when((Object)modifyEvent.getNewValues()).thenReturn(Collections.singletonList(newStyles));
        this.listener.handleModifyEvent(modifyEvent);
        CatalogPostModifyEvent postModifyEvent = (CatalogPostModifyEvent)Mockito.mock(CatalogPostModifyEvent.class);
        Mockito.when((Object)postModifyEvent.getSource()).thenReturn((Object)this.mockLayerGroupInfo);
        this.listener.handlePostModifyEvent(postModifyEvent);
        ((CatalogConfiguration)Mockito.verify((Object)this.mockConfiguration)).truncate((String)Matchers.eq((Object)LAYER_GROUP_NAME));
    }

    public void testLayerInfoDefaultStyleChanged() throws Exception {
        String oldName = "oldStyle";
        String newName = "newStyle";
        StyleInfo oldStyle = (StyleInfo)Mockito.mock(StyleInfo.class);
        Mockito.when((Object)oldStyle.getName()).thenReturn((Object)"oldStyle");
        StyleInfo newStyle = (StyleInfo)Mockito.mock(StyleInfo.class);
        Mockito.when((Object)newStyle.getName()).thenReturn((Object)"newStyle");
        Mockito.when((Object)this.mockLayerInfo.getDefaultStyle()).thenReturn((Object)newStyle);
        CatalogModifyEvent modifyEvent = (CatalogModifyEvent)Mockito.mock(CatalogModifyEvent.class);
        Mockito.when((Object)modifyEvent.getSource()).thenReturn((Object)this.mockLayerInfo);
        Mockito.when((Object)modifyEvent.getPropertyNames()).thenReturn(Arrays.asList("defaultStyle"));
        Mockito.when((Object)modifyEvent.getOldValues()).thenReturn(Collections.singletonList(oldStyle));
        Mockito.when((Object)modifyEvent.getNewValues()).thenReturn(Collections.singletonList(newStyle));
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)Mockito.mock(GeoServerTileLayer.class);
        Mockito.when((Object)this.mockConfiguration.getTileLayer((String)Matchers.eq((Object)PREFIXED_RESOURCE_NAME))).thenReturn((Object)tileLayer);
        this.listener.handleModifyEvent(modifyEvent);
        CatalogPostModifyEvent postModifyEvent = (CatalogPostModifyEvent)Mockito.mock(CatalogPostModifyEvent.class);
        Mockito.when((Object)postModifyEvent.getSource()).thenReturn((Object)this.mockLayerInfo);
        this.listener.handlePostModifyEvent(postModifyEvent);
        ((CatalogConfiguration)Mockito.verify((Object)this.mockConfiguration)).truncate((String)Matchers.eq((Object)PREFIXED_RESOURCE_NAME), (String)Matchers.eq((Object)"oldStyle"));
        ((CatalogConfiguration)Mockito.verify((Object)this.mockConfiguration)).save((GeoServerTileLayer)Matchers.same((Object)tileLayer));
    }

    public void testLayerInfoAlternateStylesChanged() throws Exception {
        StyleInfo removedStyle = (StyleInfo)Mockito.mock(StyleInfo.class);
        Mockito.when((Object)removedStyle.getName()).thenReturn((Object)"removedStyleName");
        Set<StyleInfo> oldStyles = Collections.singleton(removedStyle);
        StyleInfo addedStyle = (StyleInfo)Mockito.mock(StyleInfo.class);
        Mockito.when((Object)addedStyle.getName()).thenReturn((Object)"addedStyleName");
        Set<StyleInfo> newStyles = Collections.singleton(addedStyle);
        CatalogModifyEvent modifyEvent = (CatalogModifyEvent)Mockito.mock(CatalogModifyEvent.class);
        Mockito.when((Object)modifyEvent.getSource()).thenReturn((Object)this.mockLayerInfo);
        Mockito.when((Object)modifyEvent.getPropertyNames()).thenReturn(Arrays.asList("styles"));
        Mockito.when((Object)modifyEvent.getOldValues()).thenReturn(Collections.singletonList(oldStyles));
        Mockito.when((Object)modifyEvent.getNewValues()).thenReturn(Collections.singletonList(newStyles));
        GeoServerTileLayerInfo info = (GeoServerTileLayerInfo)Mockito.mock(GeoServerTileLayerInfo.class);
        Mockito.when((Object)info.getCachedStyles()).thenReturn(new HashSet<String>(Arrays.asList("remainingStyle", "removedStyleName")));
        Mockito.when((Object)info.isAutoCacheStyles()).thenReturn((Object)true);
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)Mockito.mock(GeoServerTileLayer.class);
        Mockito.when((Object)tileLayer.getInfo()).thenReturn((Object)info);
        Mockito.when((Object)this.mockConfiguration.getTileLayer((String)Matchers.eq((Object)PREFIXED_RESOURCE_NAME))).thenReturn((Object)tileLayer);
        this.listener.handleModifyEvent(modifyEvent);
        CatalogPostModifyEvent postModifyEvent = (CatalogPostModifyEvent)Mockito.mock(CatalogPostModifyEvent.class);
        Mockito.when((Object)postModifyEvent.getSource()).thenReturn((Object)this.mockLayerInfo);
        this.listener.handlePostModifyEvent(postModifyEvent);
        ((CatalogConfiguration)Mockito.verify((Object)this.mockConfiguration)).truncate((String)Matchers.eq((Object)PREFIXED_RESOURCE_NAME), (String)Matchers.eq((Object)"removedStyleName"));
        ((CatalogConfiguration)Mockito.verify((Object)this.mockConfiguration)).save((GeoServerTileLayer)Matchers.same((Object)tileLayer));
    }
}

