/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.gwc.layer.CatalogConfiguration;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogLayerEventListener
implements CatalogListener {
    private static Logger log = Logging.getLogger(CatalogLayerEventListener.class);
    private final CatalogConfiguration catalogConfig;
    private static ThreadLocal<CatalogModifyEvent> PRE_MODIFY_EVENT = new ThreadLocal();

    public CatalogLayerEventListener(CatalogConfiguration catalogConfiguration) {
        this.catalogConfig = catalogConfiguration;
    }

    public void handleAddEvent(CatalogAddEvent event) throws CatalogException {
        CatalogInfo obj = event.getSource();
        if (obj instanceof LayerInfo) {
            log.finer("Handling add event: " + obj);
            LayerInfo layerInfo = (LayerInfo)obj;
            this.catalogConfig.createLayer(layerInfo);
        } else if (obj instanceof LayerGroupInfo) {
            LayerGroupInfo lgi = (LayerGroupInfo)obj;
            this.catalogConfig.createLayer(lgi);
        }
    }

    public void handleModifyEvent(CatalogModifyEvent event) throws CatalogException {
        CatalogInfo source = event.getSource();
        if (source instanceof LayerInfo || source instanceof LayerGroupInfo || source instanceof FeatureTypeInfo || source instanceof CoverageInfo || source instanceof WMSLayerInfo) {
            PRE_MODIFY_EVENT.set(event);
        }
    }

    public void handlePostModifyEvent(CatalogPostModifyEvent event) throws CatalogException {
        CatalogInfo source = event.getSource();
        if (!(source instanceof LayerInfo || source instanceof LayerGroupInfo || source instanceof FeatureTypeInfo || source instanceof CoverageInfo || source instanceof WMSLayerInfo)) {
            return;
        }
        CatalogModifyEvent preModifyEvent = PRE_MODIFY_EVENT.get();
        if (preModifyEvent == null) {
            throw new IllegalStateException("PostModifyEvent called without having called handlePreModify first?");
        }
        PRE_MODIFY_EVENT.remove();
        List changedProperties = preModifyEvent.getPropertyNames();
        List oldValues = preModifyEvent.getOldValues();
        List newValues = preModifyEvent.getNewValues();
        log.finer("Handling modify event for " + source);
        if ((source instanceof FeatureTypeInfo || source instanceof CoverageInfo || source instanceof WMSLayerInfo || source instanceof LayerGroupInfo) && (changedProperties.contains("name") || changedProperties.contains("namespace"))) {
            this.handleRename(source, changedProperties, oldValues, newValues);
        }
        if (source instanceof LayerInfo) {
            if (changedProperties.contains("defaultStyle") || changedProperties.contains("styles")) {
                LayerInfo li = (LayerInfo)source;
                this.handleLayerInfo(changedProperties, oldValues, newValues, li);
            }
        } else if (source instanceof LayerGroupInfo && (changedProperties.contains("layers") || changedProperties.contains("styles"))) {
            LayerGroupInfo lgInfo = (LayerGroupInfo)source;
            this.handleLayerGroupInfo(changedProperties, oldValues, newValues, lgInfo);
        }
    }

    private void handleLayerGroupInfo(List<String> changedProperties, List<Object> oldValues, List<Object> newValues, LayerGroupInfo lgInfo) {
        boolean truncate = false;
        if (changedProperties.contains("layers")) {
            Object newLayers;
            int layersIndex = changedProperties.indexOf("layers");
            Object oldLayers = oldValues.get(layersIndex);
            boolean bl = truncate = !oldLayers.equals(newLayers = newValues.get(layersIndex));
        }
        if (!truncate && changedProperties.contains("styles")) {
            Object newStyles;
            int stylesIndex = changedProperties.indexOf("styles");
            Object oldStyles = oldValues.get(stylesIndex);
            boolean bl = truncate = !oldStyles.equals(newStyles = newValues.get(stylesIndex));
        }
        if (truncate) {
            log.info("Truncating TileLayer for layer group '" + lgInfo.getName() + "' due to a change in its layers or styles");
            String layerName = lgInfo.getName();
            this.catalogConfig.truncate(layerName);
        }
    }

    private void handleLayerInfo(List<String> changedProperties, List<Object> oldValues, List<Object> newValues, LayerInfo li) {
        String layerName = li.getResource().getPrefixedName();
        GeoServerTileLayer tileLayer = this.catalogConfig.getTileLayer(layerName);
        boolean save = false;
        if (changedProperties.contains("defaultStyle")) {
            String newStyleName;
            int propIndex = changedProperties.indexOf("defaultStyle");
            StyleInfo oldStyle = (StyleInfo)oldValues.get(propIndex);
            StyleInfo newStyle = (StyleInfo)newValues.get(propIndex);
            String oldStyleName = oldStyle.getName();
            if (!oldStyleName.equals(newStyleName = newStyle.getName())) {
                save = true;
                this.catalogConfig.truncate(layerName, oldStyleName);
            }
        }
        if (changedProperties.contains("styles")) {
            GeoServerTileLayerInfo info = tileLayer.getInfo();
            int propIndex = changedProperties.indexOf("styles");
            Set oldStyles = (Set)oldValues.get(propIndex);
            Set currentStyles = (Set)newValues.get(propIndex);
            HashSet<String> newStyleSet = new HashSet<String>(info.getCachedStyles());
            if (!oldStyles.equals(currentStyles)) {
                HashSet removed = new HashSet(oldStyles);
                removed.removeAll(currentStyles);
                for (StyleInfo deletedStyle : removed) {
                    String styleName = deletedStyle.getName();
                    newStyleSet.remove(styleName);
                    this.catalogConfig.truncate(layerName, styleName);
                }
                if (info.isAutoCacheStyles()) {
                    HashSet added = new HashSet(currentStyles);
                    added.removeAll(oldStyles);
                    for (StyleInfo addedStyle : added) {
                        String styleName = addedStyle.getName();
                        newStyleSet.add(styleName);
                    }
                }
            }
            HashSet<String> currentStyleNames = new HashSet<String>();
            for (StyleInfo current : currentStyles) {
                currentStyleNames.add(current.getName());
            }
            newStyleSet.retainAll(currentStyleNames);
            if (!newStyleSet.equals(info.getCachedStyles())) {
                save = true;
                info.setCachedStyles(newStyleSet);
                tileLayer.resetParameterFilters();
            }
        }
        if (save) {
            this.catalogConfig.save(tileLayer);
        }
    }

    private void handleRename(Object source, List<String> changedProperties, List<Object> oldValues, List<Object> newValues) {
        String oldLayerName;
        String newLayerName;
        int nameIndex = changedProperties.indexOf("name");
        int namespaceIndex = changedProperties.indexOf("namespace");
        if (source instanceof ResourceInfo) {
            ResourceInfo resourceInfo = (ResourceInfo)source;
            NamespaceInfo currNamespace = resourceInfo.getNamespace();
            NamespaceInfo oldNamespace = namespaceIndex > -1 ? (NamespaceInfo)oldValues.get(namespaceIndex) : currNamespace;
            newLayerName = resourceInfo.getPrefixedName();
            oldLayerName = nameIndex > -1 ? (String)oldValues.get(nameIndex) : resourceInfo.getName();
            oldLayerName = String.valueOf(oldNamespace.getPrefix()) + ":" + oldLayerName;
        } else {
            oldLayerName = (String)oldValues.get(nameIndex);
            newLayerName = (String)newValues.get(nameIndex);
        }
        if (!oldLayerName.equals(newLayerName)) {
            this.catalogConfig.renameTileLayer(oldLayerName, newLayerName);
        }
    }

    public void handleRemoveEvent(CatalogRemoveEvent event) throws CatalogException {
        CatalogInfo obj = event.getSource();
        String prefixedName = null;
        if (obj instanceof LayerGroupInfo) {
            LayerGroupInfo lgInfo = (LayerGroupInfo)obj;
            prefixedName = lgInfo.getName();
        } else if (obj instanceof LayerInfo) {
            LayerInfo layerInfo = (LayerInfo)obj;
            prefixedName = layerInfo.getResource().getPrefixedName();
        }
        if (prefixedName != null) {
            this.catalogConfig.removeLayer(prefixedName);
        }
    }

    public void reloaded() {
    }
}

