/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import java.util.Iterator;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.gwc.GWC;
import org.geoserver.test.GeoServerTestSupport;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeType;

public class CatalogConfigurationTest
extends GeoServerTestSupport {
    private Catalog cat;
    private TileLayerDispatcher tld;
    private GridSetBroker gridSetBroker;

    public void _testInit() throws Exception {
        GWC gwc = GWC.get();
        this.cat = (Catalog)applicationContext.getBean("rawCatalog");
        this.tld = (TileLayerDispatcher)applicationContext.getBean("gwcTLDispatcher");
        this.gridSetBroker = (GridSetBroker)applicationContext.getBean("gwcGridSetBroker");
        try {
            this.tld.getTileLayer("");
        }
        catch (GeoWebCacheException geoWebCacheException) {
            // empty catch block
        }
        Iterable layerList = gwc.getTileLayers();
        Iterator tlIter = layerList.iterator();
        CatalogConfigurationTest.assertTrue((boolean)tlIter.hasNext());
        boolean foundLakes = false;
        while (tlIter.hasNext()) {
            TileLayer tl = (TileLayer)tlIter.next();
            if (!tl.getName().equals("cite:Lakes")) continue;
            foundLakes = true;
            break;
        }
        CatalogConfigurationTest.assertTrue((boolean)foundLakes);
        layerList = gwc.getTileLayers();
        tlIter = layerList.iterator();
        boolean foudAGF = false;
        while (tlIter.hasNext()) {
            TileLayer tl = (TileLayer)tlIter.next();
            if (!tl.getName().equals("sf:AggregateGeoFeature")) continue;
            foudAGF = true;
            GridSubset epsg4326 = tl.getGridSubset(this.gridSetBroker.WORLD_EPSG4326.getName());
            CatalogConfigurationTest.assertTrue((boolean)epsg4326.getGridSetBounds().equals((Object)new BoundingBox(-180.0, -90.0, 180.0, 90.0)));
            String mime = ((MimeType)tl.getMimeTypes().get(1)).getMimeType();
            CatalogConfigurationTest.assertTrue((mime.startsWith("image/") || mime.startsWith("application/vnd.google-earth.kml+xml") ? 1 : 0) != 0);
        }
        CatalogConfigurationTest.assertTrue((boolean)foudAGF);
        LayerInfo li = (LayerInfo)this.cat.getLayers().get(1);
        String layerName = li.getResource().getPrefixedName();
        TileLayer tl = this.tld.getTileLayer(layerName);
        CatalogConfigurationTest.assertEquals((String)layerName, (String)tl.getName());
        this.cat.remove(li);
        CatalogConfigurationTest.assertTrue((this.cat.getLayerByName(tl.getName()) == null ? 1 : 0) != 0);
        boolean caughtException = false;
        try {
            TileLayer tl2 = this.tld.getTileLayer(layerName);
        }
        catch (GeoWebCacheException gwce) {
            caughtException = true;
        }
        CatalogConfigurationTest.assertTrue((boolean)caughtException);
        ResourceInfo resInfo = li.getResource();
        resInfo.setName("hithere");
        this.cat.save(resInfo);
        LayerInfo layerInfo = this.cat.getFactory().createLayer();
        layerInfo.setResource(resInfo);
        layerInfo.setName(resInfo.getPrefixedName());
        this.cat.add(layerInfo);
        String newLayerName = layerInfo.getResource().getPrefixedName();
        TileLayer tl3 = this.tld.getTileLayer(newLayerName);
        CatalogConfigurationTest.assertEquals((String)newLayerName, (String)tl3.getName());
        LayerGroupInfo lgi = this.cat.getFactory().createLayerGroup();
        lgi.setName("sf:aLayerGroup");
        lgi.setBounds(new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, CRS.decode((String)"EPSG:4326")));
        lgi.getLayers().add(this.cat.getLayerByName("hithere"));
        this.cat.add(lgi);
        TileLayer tl4 = this.tld.getTileLayer("sf:aLayerGroup");
        CatalogConfigurationTest.assertNotNull((Object)tl4);
        CatalogConfigurationTest.assertEquals((String)lgi.getName(), (String)tl4.getName());
    }
}

