/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.wms;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.logging.Logger;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.WebMapService;
import org.geotools.util.logging.Logging;
import org.springframework.util.Assert;

public class CacheSeedingWebMapService
implements MethodInterceptor {
    private static final Logger LOGGER = Logging.getLogger(CacheSeedingWebMapService.class);

    public WebMap invoke(MethodInvocation invocation) throws Throwable {
        boolean isSeedingRequest;
        Method method = invocation.getMethod();
        Assert.isTrue((boolean)method.getDeclaringClass().equals(WebMapService.class));
        Assert.isTrue((boolean)"getMap".equals(method.getName()));
        Object[] arguments = invocation.getArguments();
        Assert.isTrue((arguments.length == 1 ? 1 : 0) != 0);
        Assert.isInstanceOf(GetMapRequest.class, (Object)arguments[0]);
        GetMapRequest request = (GetMapRequest)arguments[0];
        WebMap map = (WebMap)invocation.proceed();
        Map rawKvp = request.getRawKvp();
        boolean bl = isSeedingRequest = rawKvp != null && rawKvp.containsKey("GWC_SEED_INTERCEPT");
        if (isSeedingRequest) {
            GeoServerTileLayer.WEB_MAP.set(map);
            return null;
        }
        return map;
    }
}

