/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import net.opengis.wfs.DeleteElementType;
import net.opengis.wfs.InsertElementType;
import net.opengis.wfs.TransactionResponseType;
import net.opengis.wfs.TransactionType;
import net.opengis.wfs.UpdateElementType;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.wfs.TransactionEvent;
import org.geoserver.wfs.TransactionEventType;
import org.geoserver.wfs.TransactionPlugin;
import org.geoserver.wfs.WFSException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWCTransactionListener
implements TransactionPlugin {
    private static Logger log = Logging.getLogger(GWCTransactionListener.class);
    private final GWC gwc;
    private static final String GWC_TRANSACTION_INFO_PLACEHOLDER = "GWC_TRANSACTION_INFO_PLACEHOLDER";

    public GWCTransactionListener(GWC gwc) {
        this.gwc = gwc;
    }

    public TransactionType beforeTransaction(TransactionType request) throws WFSException {
        return request;
    }

    public void beforeCommit(TransactionType request) throws WFSException {
    }

    public void afterTransaction(TransactionType request, TransactionResponseType result, boolean committed) {
        if (!committed) {
            return;
        }
        try {
            this.afterTransactionInternal(request, committed);
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, "Error trying to truncate the transaction affected area", e);
        }
    }

    private void afterTransactionInternal(TransactionType transaction, boolean committed) {
        Map<String, List<ReferencedEnvelope>> byLayerDirtyRegions = this.getByLayerDirtyRegions(transaction);
        if (byLayerDirtyRegions.isEmpty()) {
            return;
        }
        for (String tileLayerName : byLayerDirtyRegions.keySet()) {
            ReferencedEnvelope dirtyRegion;
            List<ReferencedEnvelope> dirtyList = byLayerDirtyRegions.get(tileLayerName);
            try {
                dirtyRegion = this.merge(tileLayerName, dirtyList);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.getMessage(), e);
                continue;
            }
            if (dirtyRegion == null) continue;
            try {
                this.gwc.truncate(tileLayerName, dirtyRegion);
            }
            catch (GeoWebCacheException e) {
                log.warning("Error truncating tile layer " + tileLayerName + " for transaction affected bounds " + dirtyRegion);
            }
        }
    }

    private ReferencedEnvelope merge(String tileLayerName, List<ReferencedEnvelope> dirtyList) throws TransformException, FactoryException {
        if (dirtyList.size() == 0) {
            return null;
        }
        CoordinateReferenceSystem declaredCrs = this.getCrs(tileLayerName);
        ReferencedEnvelope merged = new ReferencedEnvelope(declaredCrs);
        for (ReferencedEnvelope env : dirtyList) {
            ReferencedEnvelope transformedDirtyRegion = env.transform(declaredCrs, true);
            merged.expandToInclude((Envelope)transformedDirtyRegion);
        }
        return merged;
    }

    private CoordinateReferenceSystem getCrs(String tileLayerName) {
        GeoServerTileLayer layer = (GeoServerTileLayer)this.gwc.getTileLayerByName(tileLayerName);
        LayerInfo layerInfo = layer.getLayerInfo();
        if (layerInfo != null) {
            return layerInfo.getResource().getCRS();
        }
        LayerGroupInfo layerGroupInfo = layer.getLayerGroupInfo();
        ReferencedEnvelope bounds = layerGroupInfo.getBounds();
        return bounds.getCoordinateReferenceSystem();
    }

    public int getPriority() {
        return 0;
    }

    public void dataStoreChange(TransactionEvent event) throws WFSException {
        log.info("DataStoreChange: " + event.getLayerName() + " " + event.getType());
        try {
            this.dataStoreChangeInternal(event);
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, "Error pre computing the transaction's affected area", e);
        }
    }

    private void dataStoreChangeInternal(TransactionEvent event) {
        Object source = event.getSource();
        if (!(source instanceof InsertElementType || source instanceof UpdateElementType || source instanceof DeleteElementType)) {
            return;
        }
        EObject originatingTransactionRequest = (EObject)source;
        Assert.notNull((Object)originatingTransactionRequest);
        TransactionEventType type = event.getType();
        if (TransactionEventType.POST_INSERT.equals((Object)type)) {
            return;
        }
        QName featureTypeName = event.getLayerName();
        Set<String> affectedTileLayers = this.gwc.getTileLayersByFeatureType(featureTypeName.getNamespaceURI(), featureTypeName.getLocalPart());
        if (affectedTileLayers.isEmpty()) {
            return;
        }
        SimpleFeatureCollection affectedFeatures = event.getAffectedFeatures();
        ReferencedEnvelope affectedBounds = affectedFeatures.getBounds();
        TransactionType transaction = event.getRequest();
        for (String tileLayerName : affectedTileLayers) {
            this.addLayerDirtyRegion(transaction, tileLayerName, affectedBounds);
        }
    }

    private Map<String, List<ReferencedEnvelope>> getByLayerDirtyRegions(TransactionType transaction) {
        Map extendedProperties = transaction.getExtendedProperties();
        HashMap byLayerDirtyRegions = (HashMap)extendedProperties.get(GWC_TRANSACTION_INFO_PLACEHOLDER);
        if (byLayerDirtyRegions == null) {
            byLayerDirtyRegions = new HashMap();
            extendedProperties.put(GWC_TRANSACTION_INFO_PLACEHOLDER, byLayerDirtyRegions);
        }
        return byLayerDirtyRegions;
    }

    private void addLayerDirtyRegion(TransactionType transaction, String tileLayerName, ReferencedEnvelope affectedBounds) {
        Map<String, List<ReferencedEnvelope>> byLayerDirtyRegions = this.getByLayerDirtyRegions(transaction);
        List<ReferencedEnvelope> layerDirtyRegion = byLayerDirtyRegions.get(tileLayerName);
        if (layerDirtyRegion == null) {
            layerDirtyRegion = new ArrayList<ReferencedEnvelope>(2);
            byLayerDirtyRegions.put(tileLayerName, layerDirtyRegion);
        }
        layerDirtyRegion.add(affectedBounds);
    }
}

