/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.config;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInitializer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.config.GWCConfigPersister;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.wms.WMSInfo;
import org.geotools.util.logging.Logging;
import org.springframework.util.Assert;

public class GWCInitializer
implements GeoServerInitializer {
    private static final Logger LOGGER = Logging.getLogger(GWCInitializer.class);
    private final GWCConfigPersister configPersister;
    private final Catalog rawCatalog;

    public GWCInitializer(GWCConfigPersister configPersister, Catalog rawCatalog) {
        this.configPersister = configPersister;
        this.rawCatalog = rawCatalog;
    }

    public void initialize(GeoServer geoServer) throws Exception {
        LOGGER.info("Initializing GeoServer specific GWC configuration from gwc-gs.xml");
        File configFile = this.configPersister.findConfigFile();
        if (configFile == null) {
            LOGGER.fine("GWC's GeoServer specific configuration not found, creating with old defaults");
            GWCConfig oldDefaults = GWCConfig.getOldDefaults();
            this.upgradeWMSIntegrationConfig(geoServer, oldDefaults);
            this.createDefaultTileLayerInfos(oldDefaults);
            this.configPersister.save(oldDefaults);
        }
        GWCConfig gwcConfig = this.configPersister.getConfig();
        Assert.notNull((Object)gwcConfig);
    }

    private void createDefaultTileLayerInfos(GWCConfig gwcConfig) {
        MetadataMap metadata;
        GeoServerTileLayerInfo tileLayerInfo;
        for (LayerInfo layer : this.rawCatalog.getLayers()) {
            try {
                tileLayerInfo = GeoServerTileLayerInfo.create(layer, gwcConfig);
                metadata = layer.getMetadata();
                tileLayerInfo.saveTo(metadata);
                this.rawCatalog.save(layer);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, "Error occurred saving default GWC Tile Layer settings for Layer '" + layer.getName() + "'", e);
            }
        }
        for (LayerInfo layer : this.rawCatalog.getLayerGroups()) {
            try {
                tileLayerInfo = GeoServerTileLayerInfo.create((LayerGroupInfo)layer, gwcConfig);
                metadata = layer.getMetadata();
                tileLayerInfo.saveTo(metadata);
                this.rawCatalog.save((LayerGroupInfo)layer);
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, "Error occurred saving default GWC Tile Layer settings for LayerGroup '" + layer.getName() + "'", e);
            }
        }
    }

    private void upgradeWMSIntegrationConfig(GeoServer geoServer, GWCConfig gwcConfig) throws IOException {
        WMSInfo service = (WMSInfo)geoServer.getService(WMSInfo.class);
        if (service != null) {
            String WMS_INTEGRATION_ENABLED_KEY;
            Boolean storedValue;
            MetadataMap metadata = service.getMetadata();
            if (service != null && metadata != null && (storedValue = (Boolean)metadata.get(WMS_INTEGRATION_ENABLED_KEY = "GWC_WMS_Integration", Boolean.class)) != null) {
                boolean enabled = storedValue;
                gwcConfig.setDirectWMSIntegrationEnabled(enabled);
                metadata.remove((Object)WMS_INTEGRATION_ENABLED_KEY);
                geoServer.save((ServiceInfo)service);
                this.configPersister.save(gwcConfig);
            }
        }
    }
}

