/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.HashMap;
import java.util.Map;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.DataAccessLimits;
import org.geoserver.security.ResourceAccessManager;
import org.geoserver.security.WorkspaceAccessLimits;
import org.springframework.security.Authentication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestResourceAccessManager
implements ResourceAccessManager {
    Map<String, Map<String, AccessLimits>> limits = new HashMap<String, Map<String, AccessLimits>>();

    public WorkspaceAccessLimits getAccessLimits(Authentication user, WorkspaceInfo workspace) {
        if (user == null) {
            return null;
        }
        String name = user.getName();
        return (WorkspaceAccessLimits)this.getUserMap(name).get(workspace.getId());
    }

    public DataAccessLimits getAccessLimits(Authentication user, LayerInfo layer) {
        if (user == null) {
            return null;
        }
        String name = user.getName();
        DataAccessLimits limits = (DataAccessLimits)this.getUserMap(name).get(layer.getId());
        if (limits == null) {
            limits = this.getAccessLimits(user, layer.getResource());
        }
        return limits;
    }

    public DataAccessLimits getAccessLimits(Authentication user, ResourceInfo resource) {
        if (user == null) {
            return null;
        }
        String name = user.getName();
        return (DataAccessLimits)this.getUserMap(name).get(resource.getId());
    }

    public void putLimits(String userName, CatalogInfo securedItem, AccessLimits limits) {
        this.getUserMap(userName).put(securedItem.getId(), limits);
    }

    Map<String, AccessLimits> getUserMap(String userName) {
        Map<String, AccessLimits> userMap = this.limits.get(userName);
        if (userMap == null) {
            userMap = new HashMap<String, AccessLimits>();
            this.limits.put(userName, userMap);
        }
        return userMap;
    }
}

