/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.crs;

import java.io.File;
import org.geoserver.test.GeoServerTestSupport;
import org.geotools.referencing.CRS;
import org.geotools.referencing.datum.BursaWolfParameters;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;

public class OvverideCRSTest
extends GeoServerTestSupport {
    @Override
    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        new File(this.getTestData().getDataDirectoryRoot(), "epsg").mkdir();
        this.getTestData().copyTo(OvverideCRSTest.class.getResourceAsStream("override_epsg.properties"), "epsg/override_epsg.properties");
    }

    public void testOverride() throws Exception {
        CoordinateReferenceSystem epsg3003 = CRS.decode((String)"EPSG:3003");
        DefaultGeodeticDatum datum3003 = (DefaultGeodeticDatum)((ProjectedCRS)epsg3003).getDatum();
        BursaWolfParameters[] bwParamArray3003 = datum3003.getBursaWolfParameters();
        OvverideCRSTest.assertEquals((int)1, (int)bwParamArray3003.length);
        BursaWolfParameters bw3003 = bwParamArray3003[0];
        OvverideCRSTest.assertEquals((Object)-104.1, (Object)bw3003.dx);
        OvverideCRSTest.assertEquals((Object)-49.1, (Object)bw3003.dy);
        OvverideCRSTest.assertEquals((Object)-9.9, (Object)bw3003.dz);
        OvverideCRSTest.assertEquals((Object)0.971, (Object)bw3003.ex);
        OvverideCRSTest.assertEquals((Object)-2.917, (Object)bw3003.ey);
        OvverideCRSTest.assertEquals((Object)0.714, (Object)bw3003.ez);
        OvverideCRSTest.assertEquals((Object)-11.68, (Object)bw3003.ppm);
        CoordinateReferenceSystem epsg3002 = CRS.decode((String)"EPSG:3002");
        DefaultGeodeticDatum datum3002 = (DefaultGeodeticDatum)((ProjectedCRS)epsg3002).getDatum();
        BursaWolfParameters[] bwParamArray3002 = datum3002.getBursaWolfParameters();
        OvverideCRSTest.assertEquals((int)1, (int)bwParamArray3002.length);
        BursaWolfParameters bw3002 = bwParamArray3002[0];
        OvverideCRSTest.assertFalse((boolean)bw3002.equals((Object)bw3003));
    }
}

