/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.apache.commons.collections.map.AbstractHashedMap;
import org.apache.commons.collections.map.AbstractLinkedMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.io.IOUtils;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogVisitorAdapter;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.data.util.CoverageStoreUtils;
import org.geoserver.data.util.CoverageUtils;
import org.geoserver.feature.retype.RetypingDataStore;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.styling.SLDParser;
import org.geotools.styling.SLDTransformer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.vfny.geoserver.global.GeoServerFeatureLocking;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.util.DataStoreUtils;

public class ResourcePool {
    public static Hints.Key REPROJECT = new Hints.Key(Boolean.class);
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.catalog");
    static Class VERSIONING_FS = null;
    static Class GS_VERSIONING_FS = null;
    HashMap<String, CoordinateReferenceSystem> crsCache = new HashMap();
    DataStoreCache dataStoreCache = new DataStoreCache();
    FeatureTypeCache featureTypeCache = new FeatureTypeCache();
    CoverageReaderCache coverageReaderCache = new CoverageReaderCache();
    CoverageReaderCache hintCoverageReaderCache = new CoverageReaderCache();
    HashMap<StyleInfo, Style> styleCache = new HashMap();

    public ResourcePool(Catalog catalog) {
        catalog.addListener(new CacheClearingListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoordinateReferenceSystem getCRS(String srsName) throws IOException {
        if (srsName == null) {
            return null;
        }
        CoordinateReferenceSystem crs = this.crsCache.get(srsName);
        if (crs == null) {
            HashMap<String, CoordinateReferenceSystem> hashMap = this.crsCache;
            synchronized (hashMap) {
                crs = this.crsCache.get(srsName);
                if (crs == null) {
                    try {
                        crs = CRS.decode((String)srsName);
                        this.crsCache.put(srsName, crs);
                    }
                    catch (Exception e) {
                        throw (IOException)new IOException().initCause(e);
                    }
                }
            }
        }
        return crs;
    }

    public DataAccessFactory getDataStoreFactory(DataStoreInfo info) throws IOException {
        DataAccessFactory factory = null;
        if (info.getType() != null) {
            factory = DataStoreUtils.aquireFactory(info.getType());
        }
        if (factory == null) {
            factory = DataStoreUtils.aquireFactory(ResourcePool.getParams(info.getConnectionParameters(), GeoserverDataDirectory.getGeoserverDataDirectory().getCanonicalPath()));
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataAccess<? extends FeatureType, ? extends Feature> getDataStore(DataStoreInfo info) throws IOException {
        try {
            String id = info.getId();
            DataAccess dataStore = (DataAccess)this.dataStoreCache.get(id);
            if (dataStore == null) {
                DataStoreCache dataStoreCache = this.dataStoreCache;
                synchronized (dataStoreCache) {
                    dataStore = (DataAccess)this.dataStoreCache.get(id);
                    if (dataStore == null) {
                        Map connectionParameters = info.getConnectionParameters();
                        if (!(connectionParameters = DataStoreUtils.getParams(connectionParameters, null)).containsKey("namespace")) {
                            DataAccessFactory factory = null;
                            try {
                                factory = this.getDataStoreFactory(info);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            boolean supportsNamespace = true;
                            if (factory != null) {
                                DataAccessFactory.Param[] params;
                                supportsNamespace = false;
                                for (DataAccessFactory.Param p : params = factory.getParametersInfo()) {
                                    if (!"namespace".equalsIgnoreCase(p.key)) continue;
                                    supportsNamespace = true;
                                    break;
                                }
                            }
                            if (supportsNamespace) {
                                WorkspaceInfo ws = info.getWorkspace();
                                NamespaceInfo ns = info.getCatalog().getNamespaceByPrefix(ws.getName());
                                if (ns == null) {
                                    ns = info.getCatalog().getDefaultNamespace();
                                }
                                if (ns != null) {
                                    connectionParameters.put("namespace", ns.getURI());
                                }
                            }
                        }
                        if ((dataStore = DataStoreUtils.getDataAccess(connectionParameters)) == null) {
                            dataStore = DataAccessFinder.getDataStore((Map)connectionParameters);
                        }
                        if (dataStore == null) {
                            throw new NullPointerException("Could not acquire data access '" + info.getName() + "'");
                        }
                        this.dataStoreCache.put(id, dataStore);
                    }
                }
            }
            return dataStore;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public static Map getParams(Map m, String baseDir) {
        Map params = Collections.synchronizedMap(new HashMap(m));
        for (Map.Entry entry : params.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            try {
                if (key != null && key.matches(".* *url") && value instanceof String) {
                    String path = (String)value;
                    if (!path.startsWith("file:")) continue;
                    File fixedPath = GeoserverDataDirectory.findDataFile(path);
                    entry.setValue(fixedPath.toURL().toExternalForm());
                    continue;
                }
                if (!(value instanceof URL) || !((URL)value).getProtocol().equals("file")) continue;
                File fixedPath = GeoserverDataDirectory.findDataFile(((URL)value).toString());
                entry.setValue(fixedPath.toURL());
            }
            catch (MalformedURLException ignore) {}
        }
        return params;
    }

    public void clear(DataStoreInfo info) {
        this.dataStoreCache.remove(info.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(DataStoreInfo info) {
        DataAccess dataStore = (DataAccess)this.dataStoreCache.get(info);
        if (dataStore != null) {
            DataStoreCache dataStoreCache = this.dataStoreCache;
            synchronized (dataStoreCache) {
                dataStore = (DataAccess)this.dataStoreCache.get(info);
                if (dataStore != null) {
                    try {
                        dataStore.dispose();
                    }
                    catch (Exception e) {
                        LOGGER.warning("Error occured disposing data store '" + info.getName() + "'");
                        LOGGER.log(Level.FINE, "", e);
                    }
                    this.dataStoreCache.remove(info);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureType getFeatureType(FeatureTypeInfo info) throws IOException {
        FeatureType ft = (FeatureType)this.featureTypeCache.get(info);
        if (ft == null) {
            FeatureTypeCache featureTypeCache = this.featureTypeCache;
            synchronized (featureTypeCache) {
                ft = (FeatureType)this.featureTypeCache.get(info);
                if (ft == null) {
                    DataAccess<? extends FeatureType, ? extends Feature> dataAccess = this.getDataStore(info.getStore());
                    ft = dataAccess.getSchema(info.getQualifiedNativeName());
                    if (ft instanceof SimpleFeatureType) {
                        SimpleFeatureType sft = (SimpleFeatureType)ft;
                        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
                        tb.setName(info.getName());
                        tb.setNamespaceURI(info.getNamespace().getURI());
                        if (info.getAttributes() == null || info.getAttributes().isEmpty()) {
                            for (PropertyDescriptor pd : ft.getDescriptors()) {
                                if (!(pd instanceof AttributeDescriptor)) continue;
                                AttributeDescriptor ad = (AttributeDescriptor)pd;
                                ad = this.handleDescriptor(ad, info);
                                tb.add(ad);
                            }
                        } else {
                            for (AttributeTypeInfo att : info.getAttributes()) {
                                String attName = att.getName();
                                PropertyDescriptor pd = ft.getDescriptor(attName);
                                if (pd == null || !(pd instanceof AttributeDescriptor)) {
                                    throw new IOException("the SimpleFeatureType " + info.getPrefixedName() + " does not contains the configured attribute " + attName + ". Check your schema configuration");
                                }
                                AttributeDescriptor ad = (AttributeDescriptor)pd;
                                ad = this.handleDescriptor(ad, info);
                                tb.add(ad);
                            }
                        }
                        ft = tb.buildFeatureType();
                    }
                    this.featureTypeCache.put(info, ft);
                }
            }
        }
        return ft;
    }

    AttributeDescriptor handleDescriptor(AttributeDescriptor ad, FeatureTypeInfo info) {
        if (ad instanceof GeometryDescriptor) {
            GeometryDescriptor old = (GeometryDescriptor)ad;
            try {
                boolean rebuild = false;
                if (old.getCoordinateReferenceSystem() == null) {
                    info.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
                    rebuild = true;
                } else {
                    ProjectionPolicy projPolicy = info.getProjectionPolicy();
                    if (projPolicy == ProjectionPolicy.REPROJECT_TO_DECLARED || projPolicy == ProjectionPolicy.FORCE_DECLARED) {
                        rebuild = true;
                    }
                }
                if (rebuild) {
                    AttributeTypeBuilder b = new AttributeTypeBuilder();
                    b.init((AttributeDescriptor)old);
                    b.setCRS(this.getCRS(info.getSRS()));
                    ad = b.buildDescriptor(old.getLocalName());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return ad;
    }

    public AttributeDescriptor getAttributeDescriptor(FeatureTypeInfo ftInfo, AttributeTypeInfo atInfo) throws Exception {
        FeatureType featureType = this.getFeatureType(ftInfo);
        if (featureType != null) {
            for (PropertyDescriptor pd : featureType.getDescriptors()) {
                if (!(pd instanceof AttributeDescriptor)) continue;
                AttributeDescriptor ad = (AttributeDescriptor)pd;
                if (!atInfo.getName().equals(ad.getLocalName())) continue;
                return ad;
            }
        }
        return null;
    }

    public void clear(FeatureTypeInfo info) {
        this.featureTypeCache.remove(info);
    }

    public FeatureSource<? extends FeatureType, ? extends Feature> getFeatureSource(FeatureTypeInfo info, Hints hints) throws IOException {
        List<AttributeTypeInfo> attributes;
        ProjectionPolicy ppolicy;
        FeatureSource<SimpleFeatureType, SimpleFeature> fs;
        DataAccess<? extends FeatureType, ? extends Feature> dataAccess = this.getDataStore(info.getStore());
        if (!(dataAccess instanceof DataStore)) {
            return dataAccess.getFeatureSource(info.getQualifiedName());
        }
        DataStore dataStore = (DataStore)dataAccess;
        final String typeName = info.getNativeName();
        final String alias = info.getName();
        SimpleFeatureType nativeFeatureType = dataStore.getSchema(typeName);
        final SimpleFeatureType featureType = (SimpleFeatureType)this.getFeatureType(info);
        if (!typeName.equals(alias) || DataUtilities.compare((SimpleFeatureType)nativeFeatureType, (SimpleFeatureType)featureType) != 0) {
            RetypingDataStore retyper = new RetypingDataStore(dataStore){

                @Override
                protected String transformFeatureTypeName(String originalName) {
                    if (!typeName.equals(originalName)) {
                        return originalName;
                    }
                    return alias;
                }

                @Override
                protected SimpleFeatureType transformFeatureType(SimpleFeatureType original) throws IOException {
                    if (original.getTypeName().equals(typeName)) {
                        return featureType;
                    }
                    return super.transformFeatureType(original);
                }
            };
            fs = retyper.getFeatureSource(alias);
        } else {
            fs = dataStore.getFeatureSource(info.getQualifiedName());
        }
        Boolean reproject = Boolean.TRUE;
        if (hints != null && hints.get((Object)REPROJECT) != null) {
            reproject = (Boolean)hints.get((Object)REPROJECT);
        }
        if ((ppolicy = info.getProjectionPolicy()) == ProjectionPolicy.REPROJECT_TO_DECLARED && !reproject.booleanValue()) {
            ppolicy = ProjectionPolicy.NONE;
        }
        if ((attributes = info.getAttributes()) == null || attributes.isEmpty()) {
            return fs;
        }
        CoordinateReferenceSystem resultCRS = null;
        GeometryDescriptor gd = ((SimpleFeatureType)fs.getSchema()).getGeometryDescriptor();
        CoordinateReferenceSystem nativeCRS = gd != null ? gd.getCoordinateReferenceSystem() : null;
        resultCRS = ppolicy == ProjectionPolicy.NONE && nativeCRS != null ? nativeCRS : this.getCRS(info.getSRS());
        SimpleFeatureType schema = (SimpleFeatureType)this.getFeatureType(info);
        try {
            if (!CRS.equalsIgnoreMetadata((Object)resultCRS, (Object)schema.getCoordinateReferenceSystem())) {
                schema = FeatureTypes.transform((SimpleFeatureType)schema, (CoordinateReferenceSystem)resultCRS);
            }
        }
        catch (Exception e) {
            throw new DataSourceException("Problem forcing CRS onto feature type", (Throwable)e);
        }
        try {
            if (VERSIONING_FS != null && GS_VERSIONING_FS != null && VERSIONING_FS.isAssignableFrom(fs.getClass())) {
                try {
                    Method m = GS_VERSIONING_FS.getMethod("create", VERSIONING_FS, SimpleFeatureType.class, Filter.class, CoordinateReferenceSystem.class, Integer.TYPE);
                    return (FeatureSource)m.invoke(null, fs, schema, info.getFilter(), resultCRS, info.getProjectionPolicy().getCode());
                }
                catch (Exception e) {
                    throw new DataSourceException("Creation of a versioning wrapper failed", (Throwable)e);
                }
            }
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        return GeoServerFeatureLocking.create(fs, schema, info.getFilter(), resultCRS, info.getProjectionPolicy().getCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridCoverageReader getGridCoverageReader(CoverageStoreInfo info, Hints hints) throws IOException {
        GridCoverageReader reader = null;
        reader = hints != null ? (GridCoverageReader)this.hintCoverageReaderCache.get(info) : (GridCoverageReader)this.coverageReaderCache.get(info);
        if (reader != null) {
            return reader;
        }
        CoverageReaderCache coverageReaderCache = hints != null ? this.hintCoverageReaderCache : this.coverageReaderCache;
        synchronized (coverageReaderCache) {
            File obj = GeoserverDataDirectory.findDataFile(info.getURL());
            reader = info.getFormat().getReader((Object)obj, hints);
            (hints != null ? this.hintCoverageReaderCache : this.coverageReaderCache).put(info, reader);
        }
        return reader;
    }

    public void clear(CoverageStoreInfo info) {
        this.coverageReaderCache.remove(info);
    }

    public GridCoverage getGridCoverage(CoverageInfo info, ReferencedEnvelope env, Hints hints) throws IOException {
        CoordinateReferenceSystem destCRS;
        ReferencedEnvelope coverageBounds;
        try {
            coverageBounds = info.boundingBox();
        }
        catch (Exception e) {
            throw (IOException)new IOException("unable to calculate coverage bounds").initCause(e);
        }
        GeneralEnvelope envelope = null;
        envelope = env == null ? new GeneralEnvelope((Envelope)coverageBounds) : new GeneralEnvelope((Envelope)env);
        CoordinateReferenceSystem sourceCRS = envelope.getCoordinateReferenceSystem();
        try {
            destCRS = info.getCRS();
        }
        catch (Exception e) {
            IOException ioe = new IOException("unable to determine coverage crs");
            ioe.initCause(e);
            throw ioe;
        }
        if (!CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)destCRS)) {
            MathTransform transform;
            try {
                transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)destCRS, (boolean)true);
            }
            catch (FactoryException e) {
                IOException ioe = new IOException("unable to determine coverage crs");
                ioe.initCause(e);
                throw ioe;
            }
            if (!transform.isIdentity()) {
                try {
                    envelope = CRS.transform((MathTransform)transform, (Envelope)envelope);
                }
                catch (TransformException e) {
                    throw (IOException)new IOException("error occured transforming envelope").initCause(e);
                }
            }
        }
        envelope.intersect((Envelope)coverageBounds);
        if (envelope.isEmpty()) {
            return null;
        }
        envelope.setCoordinateReferenceSystem(destCRS);
        GridCoverageReader reader = this.getGridCoverageReader(info.getStore(), hints);
        if (reader == null) {
            return null;
        }
        GridCoverage gc = reader.read(CoverageUtils.getParameters(reader.getFormat().getReadParameters(), info.getParameters()));
        if (gc == null || !(gc instanceof GridCoverage2D)) {
            throw new IOException("The requested coverage could not be found.");
        }
        return gc;
    }

    public AbstractGridFormat getGridCoverageFormat(CoverageStoreInfo info) {
        int length = CoverageStoreUtils.formats.length;
        for (int i = 0; i < length; ++i) {
            if (!CoverageStoreUtils.formats[i].getName().equals(info.getType())) continue;
            return (AbstractGridFormat)CoverageStoreUtils.formats[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Style getStyle(StyleInfo info) throws IOException {
        Style style = this.styleCache.get(info);
        if (style == null) {
            HashMap<StyleInfo, Style> hashMap = this.styleCache;
            synchronized (hashMap) {
                style = this.styleCache.get(info);
                if (style == null) {
                    StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);
                    File styleFile = GeoserverDataDirectory.findStyleFile(info.getFilename());
                    if (styleFile == null) {
                        throw new IOException("No such file: " + info.getFilename());
                    }
                    SLDParser stylereader = new SLDParser(styleFactory, styleFile);
                    style = stylereader.readXML()[0];
                    style.setName(info.getName());
                    this.styleCache.put(info, style);
                }
            }
        }
        return style;
    }

    public void clear(StyleInfo info) {
        this.styleCache.remove(info);
    }

    public BufferedReader readStyle(StyleInfo style) throws IOException {
        File styleFile = GeoserverDataDirectory.findStyleFile(style.getFilename());
        if (styleFile == null) {
            throw new IOException("No such file: " + style.getFilename());
        }
        return new BufferedReader(new InputStreamReader(new FileInputStream(styleFile)));
    }

    public void writeStyle(StyleInfo info, Style style) throws IOException {
        this.writeStyle(info, style, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStyle(StyleInfo info, Style style, boolean format) throws IOException {
        HashMap<StyleInfo, Style> hashMap = this.styleCache;
        synchronized (hashMap) {
            File styleFile = GeoserverDataDirectory.findStyleFile(info.getFilename(), true);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(styleFile));
            try {
                SLDTransformer tx = new SLDTransformer();
                if (format) {
                    tx.setIndentation(2);
                }
                try {
                    tx.transform((Object)style, (OutputStream)out);
                }
                catch (TransformerException e) {
                    throw (IOException)new IOException("Error writing style").initCause(e);
                }
                this.clear(info);
            }
            finally {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStyle(StyleInfo style, InputStream in) throws IOException {
        HashMap<StyleInfo, Style> hashMap = this.styleCache;
        synchronized (hashMap) {
            File styleFile = GeoserverDataDirectory.findStyleFile(style.getFilename(), true);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(styleFile));
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out);
                out.flush();
                this.clear(style);
            }
            finally {
                out.close();
            }
        }
    }

    public void dispose() {
        this.crsCache.clear();
        this.dataStoreCache.clear();
        this.featureTypeCache.clear();
        this.coverageReaderCache.clear();
        this.hintCoverageReaderCache.clear();
        this.styleCache.clear();
    }

    static {
        try {
            VERSIONING_FS = Class.forName("org.geotools.data.VersioningFeatureSource");
            GS_VERSIONING_FS = Class.forName("org.vfny.geoserver.global.GeoServerVersioningFeatureSource");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    class CacheClearingListener
    extends CatalogVisitorAdapter
    implements CatalogListener {
        CacheClearingListener() {
        }

        @Override
        public void handleAddEvent(CatalogAddEvent event) {
        }

        @Override
        public void handleModifyEvent(CatalogModifyEvent event) {
        }

        @Override
        public void handlePostModifyEvent(CatalogPostModifyEvent event) {
            event.getSource().accept(this);
        }

        @Override
        public void handleRemoveEvent(CatalogRemoveEvent event) {
            event.getSource().accept(this);
        }

        @Override
        public void reloaded() {
        }

        @Override
        public void visit(DataStoreInfo dataStore) {
            ResourcePool.this.clear(dataStore);
        }

        @Override
        public void visit(CoverageStoreInfo coverageStore) {
            ResourcePool.this.clear(coverageStore);
        }

        @Override
        public void visit(FeatureTypeInfo featureType) {
            ResourcePool.this.clear(featureType);
        }

        @Override
        public void visit(StyleInfo style) {
            ResourcePool.this.clear(style);
        }
    }

    static class CoverageReaderCache
    extends LRUMap {
        CoverageReaderCache() {
        }

        protected boolean removeLRU(AbstractLinkedMap.LinkEntry entry) {
            CoverageStoreInfo info = (CoverageStoreInfo)entry.getKey();
            this.dispose(info, (GridCoverageReader)entry.getValue());
            return super.removeLRU(entry);
        }

        void dispose(CoverageStoreInfo info, GridCoverageReader reader) {
            LOGGER.info("Disposing grid coverage reader '" + info.getName() + "'");
            try {
                reader.dispose();
            }
            catch (Exception e) {
                LOGGER.warning("Error occured disposing coverage reader '" + info.getName() + "'");
                LOGGER.log(Level.FINE, "", e);
            }
        }

        protected void destroyEntry(AbstractHashedMap.HashEntry entry) {
            this.dispose((CoverageStoreInfo)entry.getKey(), (GridCoverageReader)entry.getValue());
            super.destroyEntry(entry);
        }

        public void clear() {
            for (Map.Entry entry : this.entrySet()) {
                this.dispose((CoverageStoreInfo)entry.getKey(), (GridCoverageReader)entry.getValue());
            }
            super.clear();
        }
    }

    static class DataStoreCache
    extends LRUMap {
        DataStoreCache() {
        }

        protected boolean removeLRU(AbstractLinkedMap.LinkEntry entry) {
            String name = (String)entry.getKey();
            this.dispose(name, (DataAccess)entry.getValue());
            return super.removeLRU(entry);
        }

        void dispose(String name, DataAccess dataStore) {
            LOGGER.info("Disposing datastore '" + name + "'");
            try {
                dataStore.dispose();
            }
            catch (Exception e) {
                LOGGER.warning("Error occured disposing datastore '" + name + "'");
                LOGGER.log(Level.FINE, "", e);
            }
        }

        protected void destroyEntry(AbstractHashedMap.HashEntry entry) {
            this.dispose((String)entry.getKey(), (DataAccess)entry.getValue());
            super.destroyEntry(entry);
        }

        public void clear() {
            for (Map.Entry entry : this.entrySet()) {
                this.dispose((String)entry.getKey(), (DataAccess)entry.getValue());
            }
            super.clear();
        }
    }

    static class FeatureTypeCache
    extends LRUMap {
        FeatureTypeCache() {
        }

        protected boolean removeLRU(AbstractLinkedMap.LinkEntry entry) {
            FeatureTypeInfo info = (FeatureTypeInfo)entry.getKey();
            LOGGER.info("Disposing feature type '" + info.getName() + "'");
            return super.removeLRU(entry);
        }
    }
}

