/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.xerces.parsers.SAXParser;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.util.SLDValidator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class GETMAPValidator {
    public List validateGETMAP(InputStream xml, ServletContext servContext) {
        File schemaFile = new File(GeoserverDataDirectory.getGeoserverDataDirectory(), "/data/capabilities/sld/GetMap.xsd");
        try {
            return this.validateGETMAP(xml, schemaFile.toURL().toString());
        }
        catch (Exception e) {
            ArrayList<SAXException> al = new ArrayList<SAXException>();
            al.add(new SAXException(e));
            return al;
        }
    }

    public static String getErrorMessage(InputStream xml, List errors) {
        return GETMAPValidator.getErrorMessage(new InputStreamReader(xml), errors);
    }

    public static String getErrorMessage(Reader xml, List errors) {
        return SLDValidator.getErrorMessage(xml, errors);
    }

    public List validateGETMAP(InputStream xml, String SchemaUrl) {
        return this.validateGETMAP(new InputSource(xml), SchemaUrl);
    }

    public List validateGETMAP(InputSource xml, ServletContext servContext) {
        File schemaFile = new File(GeoserverDataDirectory.getGeoserverDataDirectory(), "/data/capabilities/sld/GetMap.xsd");
        try {
            return this.validateGETMAP(xml, schemaFile.toURL().toString());
        }
        catch (Exception e) {
            ArrayList<SAXException> al = new ArrayList<SAXException>();
            al.add(new SAXException(e));
            return al;
        }
    }

    public List validateGETMAP(InputSource xml, String SchemaUrl) {
        SAXParser parser = new SAXParser();
        try {
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", false);
            parser.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", (Object)SchemaUrl);
            parser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)("http://www.opengis.net/ows " + SchemaUrl));
            Validator handler = new Validator();
            parser.setErrorHandler((ErrorHandler)handler);
            parser.parse(xml);
            return handler.errors;
        }
        catch (IOException ioe) {
            ArrayList<SAXParseException> al = new ArrayList<SAXParseException>();
            al.add(new SAXParseException(ioe.getLocalizedMessage(), null));
            return al;
        }
        catch (SAXException e) {
            ArrayList<SAXParseException> al = new ArrayList<SAXParseException>();
            al.add(new SAXParseException(e.getLocalizedMessage(), null));
            return al;
        }
    }

    private class Validator
    extends DefaultHandler {
        public ArrayList errors = new ArrayList();

        private Validator() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            if (!exception.getMessage().startsWith("TargetNamespace.2: Expecting no namespace, but the schema document has a target name")) {
                this.errors.add(exception);
            }
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.errors.add(exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }
    }
}

