/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;

public class PartialBufferedOutputStream2
extends OutputStream {
    public static final int DEFAULT_BUFFER_SIZE = 50;
    private final int KILOBYTE = 1024;
    private int BUFFER_SIZE = 1024;
    private ByteArrayOutputStream out_buffer;
    private OutputStream out_real;
    private OutputStream currentStream;
    private HttpServletResponse response;
    private boolean closed = false;

    public PartialBufferedOutputStream2(HttpServletResponse response) throws IOException {
        this(response, 50);
    }

    public PartialBufferedOutputStream2(HttpServletResponse response, int kilobytes) throws IOException {
        if (kilobytes < 1) {
            throw new IllegalArgumentException("Buffer size not greater than 0: " + kilobytes);
        }
        this.BUFFER_SIZE = 1024 * kilobytes;
        this.response = response;
        this.out_buffer = new ByteArrayOutputStream(this.BUFFER_SIZE);
        this.response = response;
        this.currentStream = this.out_buffer;
    }

    public int bufferCapacity() {
        return this.BUFFER_SIZE / 1024;
    }

    public int bufferSize() {
        return this.out_buffer.size();
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.closed) {
            return;
        }
        this.checkBuffer(1);
        this.currentStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.closed) {
            return;
        }
        this.checkBuffer(b.length);
        this.currentStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            return;
        }
        this.checkBuffer(len);
        this.currentStream.write(b, off, len);
    }

    private void checkBuffer(int extraBytes) throws IOException {
        if (this.currentStream == this.out_buffer && this.out_buffer.size() + extraBytes >= this.BUFFER_SIZE) {
            this.flushBuffer();
        }
    }

    private void flushBuffer() throws IOException {
        this.out_real = this.response.getOutputStream();
        this.out_buffer.writeTo(this.out_real);
        this.out_buffer.reset();
        this.currentStream = this.out_real;
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.currentStream == this.out_real) {
            this.currentStream.flush();
        }
    }

    public synchronized void forceFlush() throws IOException {
        if (this.currentStream == this.out_buffer) {
            this.flushBuffer();
        }
        this.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.out_buffer.close();
        this.out_buffer = null;
        this.out_real = null;
        this.response = null;
    }

    public boolean abort() throws IOException {
        if (this.out_buffer != null && this.out_buffer.size() < this.BUFFER_SIZE) {
            this.out_buffer.close();
            this.out_buffer = null;
            this.out_real = null;
            this.response = null;
            return true;
        }
        this.out_real = null;
        this.response = null;
        return false;
    }
}

