package org.geoserver.ows;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

import org.geoserver.config.ServiceInfo;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;

/**
 * Intercepts requests to all OWS services ensuring that the service is enabled.
 * 
 * @author Justin Deoliveira, OpenGEO
 *
 */
public class DisabledServiceCheck implements DispatcherCallback {

    
    public Request init(Request request) {
        return request;
    }

    public Service serviceDispatched(Request request, Service service) {
        //first get serviceInfo object from service
        Object s = service.getService();
        
        //get the getServiceInfo() method
        Method m = null;
        
        //if this object is actually proxied, we need to a big more work
        if ( s instanceof Proxy ) {
            Class[] interfaces = s.getClass().getInterfaces();
            for ( int i = 0; m == null && i < interfaces.length; i++ ) {
                m = OwsUtils.getter( interfaces[i], "service", ServiceInfo.class );
            }
        }
        else {
            m = OwsUtils.getter( s.getClass(), "service", ServiceInfo.class );
        }
        
        if ( m != null ) {
            try {
                ServiceInfo info = (ServiceInfo) m.invoke( s , null );
                
                //check if the service is enabled
                if (!info.isEnabled()) {
                    throw new ServiceException( "Service " + info.getName() + " is disabled" );
                }
            } 
            catch (Exception e) {
                //TODO: log this
                throw new ServiceException( e );
            }
        }
        
        return service;
    }

    
    public Operation operationDispatched(Request request, Operation operation) {
        return operation;
    }

    public Object operationExecuted(Request request, Operation operation,
            Object result) {
        return result;
    }

    public Response responseDispatched(Request request, Operation operation,
            Object result, Response response) {
        return response;
    }

    
    public void finished(Request request) {
    }


}
