/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.security.PropertyFileWatcher;
import org.vfny.geoserver.global.GeoserverDataDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAccessRuleDAO<R extends Comparable> {
    protected static Logger LOGGER;
    TreeSet<R> rules;
    PropertyFileWatcher watcher;
    long lastModified;
    File securityDir;
    String propertyFileName;
    GeoServerDataDirectory dd;

    protected AbstractAccessRuleDAO(GeoServerDataDirectory dd, String propertyFileName) throws IOException {
        this.dd = dd;
        this.securityDir = dd.findOrCreateSecurityRoot();
        this.propertyFileName = propertyFileName;
    }

    protected AbstractAccessRuleDAO(File securityDirectory, String propertyFileName) {
        this.securityDir = securityDirectory;
        this.propertyFileName = propertyFileName;
        this.dd = GeoserverDataDirectory.accessor();
    }

    public List<R> getRules() {
        this.checkPropertyFile(false);
        return new ArrayList<R>(this.rules);
    }

    public boolean addRule(R rule) {
        this.lastModified = System.currentTimeMillis();
        return this.rules.add(rule);
    }

    public void reload() {
        this.checkPropertyFile(true);
    }

    public void clear() {
        this.rules.clear();
        this.lastModified = System.currentTimeMillis();
    }

    public boolean removeRule(R rule) {
        this.lastModified = System.currentTimeMillis();
        return this.rules.remove(rule);
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean isModified() {
        return this.watcher != null && this.watcher.isStale();
    }

    public void storeRules() throws IOException {
        FileOutputStream os = null;
        try {
            Properties p = this.toProperties();
            File propFile = new File(this.securityDir, this.propertyFileName);
            os = new FileOutputStream(propFile);
            p.store(os, null);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (IOException)new IOException("Could not write rules to " + this.propertyFileName).initCause(e);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    void checkPropertyFile(boolean force) {
        try {
            if (this.rules == null || force) {
                if (this.securityDir == null || !this.securityDir.exists()) {
                    this.rules = new TreeSet();
                } else {
                    InputStream in;
                    File layers = new File(this.securityDir, this.propertyFileName);
                    if (!layers.exists() && (in = this.getClass().getResourceAsStream(this.propertyFileName + ".template")) != null) {
                        this.dd.copyToSecurityDir(in, this.propertyFileName);
                    }
                    if (!layers.exists()) {
                        this.rules = new TreeSet();
                    } else {
                        this.watcher = new PropertyFileWatcher(layers);
                        this.loadRules(this.watcher.getProperties());
                    }
                }
                this.lastModified = System.currentTimeMillis();
            } else if (this.isModified()) {
                this.loadRules(this.watcher.getProperties());
                this.lastModified = System.currentTimeMillis();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to reload data access rules from layers.properties, keeping old rules", e);
        }
    }

    protected abstract void loadRules(Properties var1);

    protected abstract Properties toProperties();

    protected Set<String> parseRoles(String roleCsv) {
        String[] rolesArray = roleCsv.split("[\\s,]+");
        HashSet<String> roles = new HashSet<String>(rolesArray.length);
        roles.addAll(Arrays.asList(rolesArray));
        for (String role : roles) {
            if (!"*".equals(role)) continue;
            return Collections.singleton("*");
        }
        return roles;
    }
}

