/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.vfny.geoserver.global.ConfigurationException;

public class GeoserverDataDirectory {
    public static GeoServerResourceLoader loader;
    private static Catalog catalog;
    private static ApplicationContext appContext;
    private static final Logger LOGGER;

    public static File getGeoserverDataDirectory() {
        if (loader != null) {
            return loader.getBaseDirectory();
        }
        return null;
    }

    public static String findFeatureTypeDirName(SimpleFeatureType featureType) {
        NamespaceInfo nsInfo;
        String name = featureType.getTypeName();
        String namespace = featureType.getName().getNamespaceURI();
        FeatureTypeInfo ftInfo = null;
        Catalog data = GeoserverDataDirectory.getCatalog();
        if (namespace != null && (nsInfo = data.getNamespaceByURI(namespace)) != null) {
            ftInfo = data.getFeatureTypeByName(nsInfo.getPrefix(), name);
        }
        if (ftInfo == null) {
            ftInfo = data.getFeatureTypeByName(name);
        }
        if (ftInfo == null) {
            return null;
        }
        String dirName = ftInfo.getMetadata().get("dirName", String.class);
        if (dirName == null) {
            dirName = ftInfo.getNamespace().getPrefix() + "_" + ftInfo.getName();
        }
        return dirName;
    }

    public static String findCoverageDirName(String coverageName) {
        Catalog data = GeoserverDataDirectory.getCatalog();
        CoverageInfo coverageInfo = data.getCoverageByName(coverageName);
        return coverageInfo.getMetadata().get("dirName", String.class);
    }

    public static File findConfigDir(File root, String dirName) throws ConfigurationException {
        File configDir;
        try {
            configDir = loader.find(dirName);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        return configDir;
    }

    public static File findCreateConfigDir(String dirName) throws ConfigurationException {
        File configDir = GeoserverDataDirectory.findConfigDir(GeoserverDataDirectory.getGeoserverDataDirectory(), dirName);
        if (configDir == null || !configDir.exists()) {
            configDir = new File(GeoserverDataDirectory.getGeoserverDataDirectory(), dirName);
            configDir.mkdir();
            if (configDir.exists()) {
                return configDir;
            }
        }
        return configDir;
    }

    public static File findDataFile(URL url) {
        return GeoserverDataDirectory.findDataFile(url.getFile());
    }

    public static File findStyleFile(String fileName) {
        return GeoserverDataDirectory.findStyleFile(fileName, false);
    }

    public static File findStyleFile(String fileName, boolean resolve) {
        File baseDir = GeoserverDataDirectory.getGeoserverDataDirectory();
        File styleFile = new File(new File(baseDir, "styles"), fileName);
        if (resolve || styleFile.exists()) {
            return styleFile;
        }
        return null;
    }

    public static File findDataFile(String path) {
        File baseDir = GeoserverDataDirectory.getGeoserverDataDirectory();
        if (path.startsWith("file:")) {
            File f = new File(path = path.substring(5));
            if (f.isAbsolute() || f.exists()) {
                return f;
            }
            return new File(baseDir, path);
        }
        return new File(path);
    }

    public static File findConfigFile(String file) throws ConfigurationException {
        try {
            return loader.find(file);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
    }

    public static void init(WebApplicationContext context) {
        ServletContext servContext = context.getServletContext();
        appContext = context;
        if (loader == null) {
            loader = (GeoServerResourceLoader)context.getBean("resourceLoader");
            File dataDir = null;
            String dataDirStr = GeoserverDataDirectory.findGeoServerDataDir(servContext);
            dataDir = new File(dataDirStr);
            loader.setBaseDirectory(dataDir);
            loader.addSearchLocation(new File(dataDir, "data"));
            loader.addSearchLocation(new File(dataDir, "WEB-INF"));
            LOGGER.severe("\n----------------------------------\n- GEOSERVER_DATA_DIR: " + dataDir.getAbsolutePath() + "\n----------------------------------");
            return;
        }
    }

    public static String findGeoServerDataDir(ServletContext servContext) {
        String[] typeStrs = new String[]{"Java environment variable ", "Servlet context parameter ", "System environment variable "};
        String dataDirStr = null;
        String[] varStrs = new String[]{"GEOSERVER_DATA_DIR", "GEOSERVER_DATA_ROOT"};
        String msgPrefix = null;
        int iVar = 0;
        for (int i = 0; i < varStrs.length && dataDirStr == null; ++i) {
            for (int j = 0; j < typeStrs.length && dataDirStr == null; ++j) {
                String value = null;
                String varStr = new String(varStrs[i]);
                String typeStr = typeStrs[j];
                switch (j) {
                    case 0: {
                        value = System.getProperty(varStr);
                        break;
                    }
                    case 1: {
                        value = servContext.getInitParameter(varStr);
                        break;
                    }
                    case 2: {
                        value = System.getenv(varStr);
                    }
                }
                if (value == null || value.equalsIgnoreCase("")) {
                    LOGGER.finer("Found " + typeStr + varStr + " to be unset");
                    continue;
                }
                File fh = new File(value);
                msgPrefix = "Found " + typeStr + varStr + " set to " + value;
                if (!fh.exists()) {
                    LOGGER.fine(msgPrefix + " , but this path does not exist");
                    continue;
                }
                if (!fh.isDirectory()) {
                    LOGGER.fine(msgPrefix + " , which is not a directory");
                    continue;
                }
                if (!fh.canWrite()) {
                    LOGGER.fine(msgPrefix + " , which is not writeable");
                    continue;
                }
                dataDirStr = value;
                iVar = i;
            }
        }
        if (dataDirStr == null) {
            dataDirStr = servContext.getRealPath("/data");
        }
        return dataDirStr;
    }

    public static void destroy() {
        loader = null;
        catalog = null;
    }

    private static Catalog getCatalog() {
        if (catalog == null) {
            catalog = (Catalog)GeoServerExtensions.bean((String)"catalog");
        }
        return catalog;
    }

    public static GeoServerDataDirectory accessor() {
        return new GeoServerDataDirectory(loader);
    }

    static {
        LOGGER = Logging.getLogger((String)"org.vfny.geoserver.global");
    }
}

