/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.rest.Foo;
import org.geoserver.rest.FooReflectiveResource;
import org.geoserver.rest.RestletTestSupport;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Preference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.w3c.dom.Document;

public class ReflectiveResourceTest
extends RestletTestSupport {
    public void testObjectGetAsXML() throws Exception {
        Request request = this.newRequestGET("foo.xml");
        Response response = new Response(request);
        FooReflectiveResource resource = new FooReflectiveResource(null, request, response);
        resource.handleGet();
        Document dom = this.getDOM(response);
        ReflectiveResourceTest.assertEquals((String)Foo.class.getName(), (String)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"one", (String)"//prop1", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"//prop2", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"3.0", (String)"//prop3", (Document)dom);
    }

    public void testObjectGetAsJSON() throws Exception {
        Request request = this.newRequestGET("foo.json");
        Response response = new Response(request);
        FooReflectiveResource resource = new FooReflectiveResource(null, request, response);
        resource.handleGet();
        JSON json = this.getJSON(response);
        JSONObject foo = ((JSONObject)json).getJSONObject(Foo.class.getName());
        ReflectiveResourceTest.assertNotNull((Object)foo);
        ReflectiveResourceTest.assertEquals((Object)"one", (Object)foo.get("prop1"));
        ReflectiveResourceTest.assertEquals((Object)2, (Object)foo.get("prop2"));
        ReflectiveResourceTest.assertEquals((double)3.0, (double)((Number)foo.get("prop3")).doubleValue(), (double)0.1);
    }

    public void testObjectPOSTAsXML() throws Exception {
        String xml = "<org.geoserver.rest.Foo><prop1>one</prop1><prop2>2</prop2><prop3>3.0</prop3></org.geoserver.rest.Foo>";
        Request request = this.newRequestPOST("foo", xml, "text/xml");
        Response response = new Response(request);
        FooReflectiveResource resource = new FooReflectiveResource(null, request, response);
        resource.handlePost();
        ReflectiveResourceTest.assertEquals((String)"one", (String)resource.posted.prop1);
        ReflectiveResourceTest.assertEquals((Object)new Integer(2), (Object)resource.posted.prop2);
        ReflectiveResourceTest.assertEquals((Object)new Double(3.0), (Object)resource.posted.prop3);
    }

    public void testObjectPOSTAsJSON() throws Exception {
        String json = "{'org.geoserver.rest.Foo':{'prop1':'one','prop2':2,'prop3':3}}";
        Request request = this.newRequestPOST("foo", json, "text/json");
        Response response = new Response(request);
        FooReflectiveResource resource = new FooReflectiveResource(null, request, response);
        resource.handlePost();
        ReflectiveResourceTest.assertEquals((String)"one", (String)resource.posted.prop1);
        ReflectiveResourceTest.assertEquals((Object)new Integer(2), (Object)resource.posted.prop2);
        ReflectiveResourceTest.assertEquals((Object)new Double(3.0), (Object)resource.posted.prop3);
    }

    public void testObjectPUT() throws Exception {
        String xml = "<org.geoserver.rest.Foo><prop1>one</prop1><prop2>2</prop2><prop3>3.0</prop3></org.geoserver.rest.Foo>";
        Request request = this.newRequestPOST("foo", xml, "text/xml");
        Response response = new Response(request);
        FooReflectiveResource resource = new FooReflectiveResource(null, request, response);
        resource.handlePut();
        ReflectiveResourceTest.assertEquals((String)"one", (String)resource.puted.prop1);
        ReflectiveResourceTest.assertEquals((Object)new Integer(2), (Object)resource.puted.prop2);
        ReflectiveResourceTest.assertEquals((Object)new Double(3.0), (Object)resource.puted.prop3);
    }

    public void testGetWithAcceptsHeader() throws Exception {
        Request request = this.newRequestGET("foo");
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_XML));
        Response response = new Response(request);
        FooReflectiveResource resource = new FooReflectiveResource(null, request, response);
        resource.handleGet();
        Document dom = this.getDOM(response);
        ReflectiveResourceTest.assertEquals((String)Foo.class.getName(), (String)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"one", (String)"//prop1", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"//prop2", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"3.0", (String)"//prop3", (Document)dom);
    }
}

